/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.WindowDefinition;
import com.hazelcast.util.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface WatermarkEmissionPolicy
extends Serializable {
    public boolean shouldEmit(long var1, long var3);

    @Nonnull
    public static WatermarkEmissionPolicy suppressDuplicates() {
        return (currentWm, lastEmittedWm) -> currentWm > lastEmittedWm;
    }

    @Nonnull
    public static WatermarkEmissionPolicy emitByMinStep(long minStep) {
        Preconditions.checkPositive(minStep, "minStep");
        return (currentWm, lastEmittedWm) -> currentWm >= lastEmittedWm + minStep;
    }

    @Nonnull
    public static WatermarkEmissionPolicy emitByFrame(WindowDefinition wDef) {
        return (currentWm, lastEmittedWm) -> wDef.floorFrameTs(currentWm) > lastEmittedWm;
    }
}

