/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.Processor;
import com.hazelcast.jet.ProcessorMetaSupplier;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.SerializationConstants;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import javax.annotation.Nonnull;

public class Vertex
implements IdentifiedDataSerializable {
    private ProcessorMetaSupplier supplier;
    private String name;
    private int localParallelism = -1;

    Vertex() {
    }

    public Vertex(@Nonnull String name, @Nonnull DistributedSupplier<? extends Processor> processorSupplier) {
        this(name, ProcessorMetaSupplier.of(processorSupplier));
    }

    public Vertex(@Nonnull String name, @Nonnull ProcessorSupplier processorSupplier) {
        this(name, ProcessorMetaSupplier.of(processorSupplier));
    }

    public Vertex(@Nonnull String name, @Nonnull ProcessorMetaSupplier metaSupplier) {
        Preconditions.checkNotNull(name, "name");
        Preconditions.checkNotNull(metaSupplier, "supplier");
        Util.checkSerializable(metaSupplier, "metaSupplier");
        this.supplier = metaSupplier;
        this.name = name;
    }

    @Nonnull
    public Vertex localParallelism(int localParallelism) {
        if (localParallelism < -1 || localParallelism == 0) {
            throw new IllegalArgumentException("Parallelism must be greater than 0 or -1");
        }
        this.localParallelism = localParallelism;
        return this;
    }

    public int getLocalParallelism() {
        return this.localParallelism;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public ProcessorMetaSupplier getSupplier() {
        return this.supplier;
    }

    public String toString() {
        return "Vertex " + this.name;
    }

    @Override
    public void writeData(@Nonnull ObjectDataOutput out) throws IOException {
        out.writeInt(this.localParallelism);
        out.writeUTF(this.name);
        CustomClassLoadedObject.write(out, this.supplier);
    }

    @Override
    public void readData(@Nonnull ObjectDataInput in) throws IOException {
        this.localParallelism = in.readInt();
        this.name = in.readUTF();
        this.supplier = (ProcessorMetaSupplier)CustomClassLoadedObject.read(in);
    }

    @Override
    public int getFactoryId() {
        return SerializationConstants.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 1;
    }
}

