/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.impl.util.FlatMappingTraverser;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface Traverser<T> {
    public T next();

    @Nonnull
    default public <R> Traverser<R> map(@Nonnull Function<? super T, ? extends R> mapper) {
        return () -> {
            T t = this.next();
            return t != null ? mapper.apply((T)t) : null;
        };
    }

    @Nonnull
    default public Traverser<T> filter(@Nonnull Predicate<? super T> pred) {
        return () -> {
            T t;
            while ((t = this.next()) != null) {
                if (!pred.test((T)t)) continue;
                return t;
            }
            return null;
        };
    }

    @Nonnull
    default public Traverser<T> append(final @Nonnull T item) {
        return new Traverser<T>(){
            T appendedItem;
            {
                this.appendedItem = item;
            }

            @Override
            public T next() {
                Object t = Traverser.this.next();
                if (t == null) {
                    try {
                        Object t2 = this.appendedItem;
                        return t2;
                    }
                    finally {
                        this.appendedItem = null;
                    }
                }
                return t;
            }
        };
    }

    @Nonnull
    default public Traverser<T> prepend(final @Nonnull T item) {
        return new Traverser<T>(){
            private boolean itemReturned;

            @Override
            public T next() {
                if (this.itemReturned) {
                    return Traverser.this.next();
                }
                this.itemReturned = true;
                return item;
            }
        };
    }

    @Nonnull
    default public <R> Traverser<R> flatMap(@Nonnull Function<? super T, ? extends Traverser<? extends R>> mapper) {
        return new FlatMappingTraverser(this, mapper);
    }

    @Nonnull
    default public Traverser<T> peek(@Nonnull Consumer<? super T> action) {
        return () -> {
            T t = this.next();
            if (t != null) {
                action.accept((T)t);
            }
            return t;
        };
    }

    @Nonnull
    default public Traverser<T> onFirstNull(final @Nonnull Runnable action) {
        return new Traverser<T>(){
            private boolean didRun;

            @Override
            public T next() {
                Object t = Traverser.this.next();
                if (t == null && !this.didRun) {
                    action.run();
                    this.didRun = true;
                }
                return t;
            }
        };
    }

    @SafeVarargs
    public static <T> Traverser<T> over(T ... items) {
        return Traversers.traverseArray(items);
    }
}

