/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import javax.annotation.Nonnull;

public class Session<K, R> {
    private final K key;
    private final long start;
    private final long end;
    private final R result;

    public Session(@Nonnull K key, long start, long end, @Nonnull R result) {
        this.key = key;
        this.start = start;
        this.end = end;
        this.result = result;
    }

    @Nonnull
    public K getKey() {
        return this.key;
    }

    @Nonnull
    public R getResult() {
        return this.result;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Session)) return false;
        Session that = (Session)obj;
        if (this.start != that.start) return false;
        if (this.end != that.end) return false;
        if (!this.key.equals(that.key)) return false;
        if (!this.result.equals(that.result)) return false;
        return true;
    }

    public int hashCode() {
        int hc = 17;
        hc = 73 * hc + this.key.hashCode();
        hc = 73 * hc + this.result.hashCode();
        hc = 73 * hc + Long.hashCode(this.start);
        hc = 73 * hc + Long.hashCode(this.end);
        return hc;
    }

    public String toString() {
        return this.key + "[" + this.start + ".." + this.end + "]=" + this.result;
    }
}

