/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.nio.Address;
import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface ProcessorMetaSupplier
extends Serializable {
    default public void init(@Nonnull Context context) {
    }

    @Nonnull
    public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> var1);

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull ProcessorSupplier procSupplier) {
        return ProcessorMetaSupplier.of((Address x) -> procSupplier);
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull DistributedSupplier<? extends Processor> procSupplier) {
        return ProcessorMetaSupplier.of(ProcessorSupplier.of(procSupplier));
    }

    public static ProcessorMetaSupplier of(DistributedFunction<Address, ProcessorSupplier> addressToSupplier) {
        return x -> addressToSupplier;
    }

    public static interface Context {
        @Nonnull
        public JetInstance jetInstance();

        public int totalParallelism();

        public int localParallelism();
    }
}

