/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.config.ServiceConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.HazelcastInstanceProxy;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.impl.JetClientInstanceImpl;
import com.hazelcast.jet.impl.JetInstanceImpl;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.config.XmlJetConfigBuilder;

public final class Jet {
    private Jet() {
    }

    public static JetInstance newJetInstance(JetConfig config) {
        Jet.configureJetService(config);
        HazelcastInstanceImpl hazelcastInstance = ((HazelcastInstanceProxy)Hazelcast.newHazelcastInstance(config.getHazelcastConfig())).getOriginal();
        return new JetInstanceImpl(hazelcastInstance, config);
    }

    public static JetInstance newJetInstance() {
        JetConfig config = XmlJetConfigBuilder.getConfig();
        return Jet.newJetInstance(config);
    }

    public static JetInstance newJetClient() {
        ClientConfig clientConfig = XmlJetConfigBuilder.getClientConfig();
        return Jet.newJetClient(clientConfig);
    }

    public static JetInstance newJetClient(ClientConfig config) {
        return Jet.getJetClientInstance(HazelcastClient.newHazelcastClient(config));
    }

    public static void shutdownAll() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    static JetClientInstanceImpl getJetClientInstance(HazelcastInstance client) {
        return new JetClientInstanceImpl(((HazelcastClientProxy)client).client);
    }

    static void configureJetService(JetConfig jetConfig) {
        jetConfig.getHazelcastConfig().getServicesConfig().addServiceConfig(new ServiceConfig().setEnabled(true).setName("hz:impl:jetService").setClassName(JetService.class.getName()).setConfigObject(jetConfig));
    }
}

