/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.DefaultPartitionStrategy;
import com.hazelcast.jet.Partitioner;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedFunctions;
import com.hazelcast.jet.impl.SerializationConstants;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.UuidUtil;
import java.io.IOException;
import java.io.Serializable;

public class Edge
implements IdentifiedDataSerializable {
    private Vertex source;
    private String sourceName;
    private int sourceOrdinal;
    private Vertex destination;
    private String destName;
    private int destOrdinal;
    private int priority;
    private boolean isBuffered;
    private boolean isDistributed;
    private Partitioner<?> partitioner;
    private RoutingPolicy routingPolicy = RoutingPolicy.UNICAST;
    private EdgeConfig config;

    Edge() {
    }

    private Edge(Vertex source, int sourceOrdinal, Vertex destination, int destOrdinal) {
        this.source = source;
        this.sourceName = source.getName();
        this.sourceOrdinal = sourceOrdinal;
        this.destination = destination;
        this.destName = destination != null ? destination.getName() : null;
        this.destOrdinal = destOrdinal;
    }

    public static Edge between(Vertex source, Vertex destination) {
        return new Edge(source, 0, destination, 0);
    }

    public static Edge from(Vertex source) {
        return Edge.from(source, 0);
    }

    public static Edge from(Vertex source, int ordinal) {
        return new Edge(source, ordinal, null, 0);
    }

    public Edge to(Vertex destination) {
        this.destination = destination;
        this.destName = destination.getName();
        return this;
    }

    public Edge to(Vertex destination, int ordinal) {
        this.destination = destination;
        this.destName = destination.getName();
        this.destOrdinal = ordinal;
        return this;
    }

    public Vertex getSource() {
        return this.source;
    }

    public Vertex getDestination() {
        return this.destination;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getSourceOrdinal() {
        return this.sourceOrdinal;
    }

    public String getDestName() {
        return this.destName;
    }

    public int getDestOrdinal() {
        return this.destOrdinal;
    }

    public Edge priority(int priority) {
        this.priority = priority;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public Edge buffered() {
        this.isBuffered = true;
        return this;
    }

    public boolean isBuffered() {
        return this.isBuffered;
    }

    public <T> Edge partitioned(DistributedFunction<T, ?> extractKeyF) {
        return this.partitioned(extractKeyF, Partitioner.defaultPartitioner());
    }

    public <T, K> Edge partitioned(DistributedFunction<T, K> extractKeyF, Partitioner<? super K> partitioner) {
        Util.checkSerializable(extractKeyF, "extractKeyF");
        Util.checkSerializable(partitioner, "partitioner");
        this.routingPolicy = RoutingPolicy.PARTITIONED;
        this.partitioner = new KeyPartitioner(extractKeyF, partitioner);
        return this;
    }

    public Edge allToOne() {
        return this.partitioned(DistributedFunctions.wholeItem(), new Single());
    }

    public Edge broadcast() {
        this.routingPolicy = RoutingPolicy.BROADCAST;
        return this;
    }

    public Edge isolated() {
        this.routingPolicy = RoutingPolicy.ISOLATED;
        return this;
    }

    public Partitioner<?> getPartitioner() {
        return this.partitioner;
    }

    public RoutingPolicy getRoutingPolicy() {
        return this.routingPolicy;
    }

    public Edge distributed() {
        this.isDistributed = true;
        return this;
    }

    public boolean isDistributed() {
        return this.isDistributed;
    }

    public EdgeConfig getConfig() {
        return this.config;
    }

    public Edge setConfig(EdgeConfig config) {
        this.config = config;
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.sourceOrdinal == 0 && this.destOrdinal == 0) {
            b.append("between(\"").append(this.sourceName).append("\", \"").append(this.destName).append("\")");
        } else {
            b.append("from(\"").append(this.sourceName).append('\"');
            if (this.sourceOrdinal != 0) {
                b.append(", ").append(this.sourceOrdinal);
            }
            b.append(").to(\"").append(this.destName).append('\"');
            if (this.destOrdinal != 0) {
                b.append(", ").append(this.destOrdinal);
            }
            b.append(')');
        }
        switch (this.getRoutingPolicy()) {
            case UNICAST: {
                break;
            }
            case ISOLATED: {
                b.append(".isolated()");
                break;
            }
            case PARTITIONED: {
                b.append(this.getPartitioner() instanceof Single ? ".allToOne()" : ".partitioned(?)");
                break;
            }
            case BROADCAST: {
                b.append(".broadcast()");
                break;
            }
        }
        if (this.isDistributed()) {
            b.append(".distributed()");
        }
        return b.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Edge)) return false;
        Edge that = (Edge)obj;
        if (!this.sourceName.equals(that.sourceName)) return false;
        if (!this.destName.equals(that.destName)) return false;
        return true;
    }

    public int hashCode() {
        return 37 * this.sourceName.hashCode() + this.destName.hashCode();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.sourceName);
        out.writeInt(this.sourceOrdinal);
        out.writeUTF(this.destName);
        out.writeInt(this.destOrdinal);
        out.writeInt(this.priority);
        out.writeBoolean(this.isBuffered);
        out.writeBoolean(this.isDistributed);
        out.writeObject(this.routingPolicy);
        CustomClassLoadedObject.write(out, this.partitioner);
        out.writeObject(this.config);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.sourceName = in.readUTF();
        this.sourceOrdinal = in.readInt();
        this.destName = in.readUTF();
        this.destOrdinal = in.readInt();
        this.priority = in.readInt();
        this.isBuffered = in.readBoolean();
        this.isDistributed = in.readBoolean();
        this.routingPolicy = (RoutingPolicy)in.readObject();
        this.partitioner = (Partitioner)CustomClassLoadedObject.read(in);
        this.config = (EdgeConfig)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return SerializationConstants.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 2;
    }

    private static final class KeyPartitioner<T, K>
    implements Partitioner<T> {
        private static final long serialVersionUID = 1L;
        private final DistributedFunction<T, K> keyExtractor;
        private final Partitioner<? super K> partitioner;

        KeyPartitioner(DistributedFunction<T, K> keyExtractor, Partitioner<? super K> partitioner) {
            this.keyExtractor = keyExtractor;
            this.partitioner = partitioner;
        }

        @Override
        public void init(DefaultPartitionStrategy strat) {
            this.partitioner.init(strat);
        }

        @Override
        public int getPartition(T item, int partitionCount) {
            return this.partitioner.getPartition(this.keyExtractor.apply(item), partitionCount);
        }
    }

    private static class Single
    implements Partitioner<Object> {
        private static final long serialVersionUID = 1L;
        private final String key = UuidUtil.newUnsecureUuidString();
        private int partition;

        Single() {
        }

        @Override
        public void init(DefaultPartitionStrategy strat) {
            this.partition = strat.getPartition(this.key);
        }

        @Override
        public int getPartition(Object item, int partitionCount) {
            return this.partition;
        }
    }

    public static enum RoutingPolicy implements Serializable
    {
        UNICAST,
        ISOLATED,
        PARTITIONED,
        BROADCAST;

    }
}

