/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.Edge;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.ProcessorMetaSupplier;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.DagValidator;
import com.hazelcast.jet.impl.SerializationConstants;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DAG
implements IdentifiedDataSerializable,
Iterable<Vertex> {
    private Set<Edge> edges = new LinkedHashSet<Edge>();
    private Map<String, Vertex> verticesByName = new HashMap<String, Vertex>();
    private Set<Vertex> verticesByIdentity = Collections.newSetFromMap(new IdentityHashMap());

    public Vertex newVertex(String name, DistributedSupplier<? extends Processor> simpleSupplier) {
        return this.addVertex(new Vertex(name, simpleSupplier));
    }

    public Vertex newVertex(String name, ProcessorSupplier processorSupplier) {
        return this.addVertex(new Vertex(name, processorSupplier));
    }

    public Vertex newVertex(String name, ProcessorMetaSupplier metaSupplier) {
        return this.addVertex(new Vertex(name, metaSupplier));
    }

    public DAG vertex(Vertex vertex) {
        this.addVertex(vertex);
        return this;
    }

    public DAG edge(Edge edge) {
        if (edge.getDestination() == null) {
            throw new IllegalArgumentException("Edge has no destination");
        }
        if (this.edges.contains(edge)) {
            throw new IllegalArgumentException("This DAG already has an edge between '" + edge.getSourceName() + "' and '" + edge.getDestName() + '\'');
        }
        if (!this.containsVertex(edge.getSource())) {
            throw new IllegalArgumentException(this.containsVertexName(edge.getSource()) ? "This DAG has a vertex called '" + edge.getSourceName() + "', but the supplied edge's source is a different vertex with the same name" : "Source vertex '" + edge.getSourceName() + "' is not in this DAG");
        }
        if (!this.containsVertex(edge.getDestination())) {
            throw new IllegalArgumentException(this.containsVertexName(edge.getDestination()) ? "This DAG has a vertex called '" + edge.getDestName() + "', but the supplied edge's destination is a different vertex with the same name" : "Destination vertex '" + edge.getDestName() + "' is not in this DAG");
        }
        if (this.getInboundEdges(edge.getDestName()).stream().anyMatch(e -> e.getDestOrdinal() == edge.getDestOrdinal())) {
            throw new IllegalArgumentException("Vertex '" + edge.getDestName() + "' already has an inbound edge at ordinal " + edge.getDestOrdinal() + (edge.getSourceOrdinal() == 0 && edge.getDestOrdinal() == 0 ? ", use Edge.from().to() to specify another ordinal" : ""));
        }
        if (this.getOutboundEdges(edge.getSourceName()).stream().anyMatch(e -> e.getSourceOrdinal() == edge.getSourceOrdinal())) {
            throw new IllegalArgumentException("Vertex '" + edge.getSourceName() + "' already has an outbound edge at ordinal " + edge.getSourceOrdinal() + (edge.getSourceOrdinal() == 0 && edge.getDestOrdinal() == 0 ? ", use Edge.from().to() to specify another ordinal" : ""));
        }
        this.edges.add(edge);
        return this;
    }

    public List<Edge> getInboundEdges(String vertexName) {
        if (!this.verticesByName.containsKey(vertexName)) {
            throw new IllegalArgumentException("No vertex with name '" + vertexName + "' found in this DAG");
        }
        ArrayList<Edge> inboundEdges = new ArrayList<Edge>();
        for (Edge edge : this.edges) {
            if (!edge.getDestName().equals(vertexName)) continue;
            inboundEdges.add(edge);
        }
        return inboundEdges;
    }

    public List<Edge> getOutboundEdges(String vertexName) {
        if (!this.verticesByName.containsKey(vertexName)) {
            throw new IllegalArgumentException("No vertex with name '" + vertexName + "' found in this DAG");
        }
        ArrayList<Edge> outboundEdges = new ArrayList<Edge>();
        for (Edge edge : this.edges) {
            if (!edge.getSourceName().equals(vertexName)) continue;
            outboundEdges.add(edge);
        }
        return outboundEdges;
    }

    public Vertex getVertex(String vertexName) {
        return this.verticesByName.get(vertexName);
    }

    public Iterator<Vertex> reverseIterator() {
        return Collections.unmodifiableCollection(this.validate()).iterator();
    }

    @Override
    public Iterator<Vertex> iterator() {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(this.validate());
        Collections.reverse(vertices);
        return Collections.unmodifiableCollection(vertices).iterator();
    }

    Collection<Vertex> validate() {
        return new DagValidator().validate(this.verticesByName, this.edges);
    }

    private Vertex addVertex(Vertex vertex) {
        if (this.verticesByName.containsKey(vertex.getName())) {
            throw new IllegalArgumentException("Vertex " + vertex.getName() + " is already defined.");
        }
        this.verticesByIdentity.add(vertex);
        this.verticesByName.put(vertex.getName(), vertex);
        return vertex;
    }

    private boolean containsVertex(Vertex vertex) {
        return this.verticesByIdentity.contains(vertex);
    }

    private boolean containsVertexName(Vertex vertex) {
        return this.verticesByName.containsKey(vertex.getName());
    }

    public String toString() {
        StringBuilder b = new StringBuilder("dag\n");
        for (Vertex v : this) {
            b.append("    .vertex(\"").append(v.getName()).append("\")");
            if (v.getLocalParallelism() != -1) {
                b.append(".localParallelism(").append(v.getLocalParallelism()).append(')');
            }
            b.append('\n');
        }
        for (Edge e : this.edges) {
            b.append("    .edge(").append(e).append(")\n");
        }
        return b.toString();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.verticesByName.size());
        for (Map.Entry<String, Vertex> entry : this.verticesByName.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeInt(this.edges.size());
        for (Edge edge : this.edges) {
            out.writeObject(edge);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int vertexCount = in.readInt();
        for (int i = 0; i < vertexCount; ++i) {
            String key = (String)in.readObject();
            Vertex value = (Vertex)in.readObject();
            this.verticesByName.put(key, value);
        }
        int edgeCount = in.readInt();
        for (int i = 0; i < edgeCount; ++i) {
            Edge edge = (Edge)in.readObject();
            this.edges.add(edge);
        }
    }

    @Override
    public int getFactoryId() {
        return SerializationConstants.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 0;
    }
}

