/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.AggregateOperation;
import com.hazelcast.jet.accumulator.DoubleAccumulator;
import com.hazelcast.jet.accumulator.LinTrendAccumulator;
import com.hazelcast.jet.accumulator.LongAccumulator;
import com.hazelcast.jet.accumulator.LongDoubleAccumulator;
import com.hazelcast.jet.accumulator.LongLongAccumulator;
import com.hazelcast.jet.accumulator.MutableReference;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedBinaryOperator;
import com.hazelcast.jet.function.DistributedComparator;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.function.DistributedToDoubleFunction;
import com.hazelcast.jet.function.DistributedToLongFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AggregateOperations {
    private AggregateOperations() {
    }

    @Nonnull
    public static AggregateOperation<Object, LongAccumulator, Long> counting() {
        return AggregateOperation.of(LongAccumulator::new, (a, item) -> a.addExact(1L), LongAccumulator::addExact, LongAccumulator::subtract, LongAccumulator::get);
    }

    @Nonnull
    public static <T> AggregateOperation<T, LongAccumulator, Long> summingLong(@Nonnull DistributedToLongFunction<T> mapToLongF) {
        return AggregateOperation.of(LongAccumulator::new, (a, item) -> a.addExact(mapToLongF.applyAsLong(item)), LongAccumulator::addExact, LongAccumulator::subtractExact, LongAccumulator::get);
    }

    @Nonnull
    public static <T> AggregateOperation<T, DoubleAccumulator, Double> summingDouble(@Nonnull DistributedToDoubleFunction<T> mapToDoubleF) {
        return AggregateOperation.of(DoubleAccumulator::new, (a, item) -> a.add(mapToDoubleF.applyAsDouble(item)), DoubleAccumulator::add, DoubleAccumulator::subtract, DoubleAccumulator::get);
    }

    @Nonnull
    public static <T> AggregateOperation<T, MutableReference<T>, T> minBy(@Nonnull DistributedComparator<? super T> comparator) {
        return AggregateOperations.maxBy(comparator.reversed());
    }

    @Nonnull
    public static <T> AggregateOperation<T, MutableReference<T>, T> maxBy(@Nonnull DistributedComparator<? super T> comparator) {
        return AggregateOperation.of(MutableReference::new, (a, i) -> {
            if (a.get() == null || comparator.compare(i, a.get()) > 0) {
                a.set(i);
            }
        }, (a1, a2) -> {
            if (a1.get() == null || comparator.compare((Object)a1.get(), (Object)a2.get()) < 0) {
                a1.set(a2.get());
            }
        }, null, MutableReference::get);
    }

    @Nonnull
    public static <T> AggregateOperation<T, LongLongAccumulator, Double> averagingLong(@Nonnull DistributedToLongFunction<T> mapToLongF) {
        return AggregateOperation.of(LongLongAccumulator::new, (a, i) -> {
            if (a.getValue1() == Long.MAX_VALUE) {
                throw new ArithmeticException("long overflow");
            }
            a.setValue1(a.getValue1() + 1L);
            a.setValue2(Math.addExact(a.getValue2(), mapToLongF.applyAsLong(i)));
        }, (a1, a2) -> {
            a1.setValue1(Math.addExact(a1.getValue1(), a2.getValue1()));
            a1.setValue2(Math.addExact(a1.getValue2(), a2.getValue2()));
        }, (a1, a2) -> {
            a1.setValue1(Math.subtractExact(a1.getValue1(), a2.getValue1()));
            a1.setValue2(Math.subtractExact(a1.getValue2(), a2.getValue2()));
        }, a -> (double)a.getValue2() / (double)a.getValue1());
    }

    @Nonnull
    public static <T> AggregateOperation<T, LongDoubleAccumulator, Double> averagingDouble(@Nonnull DistributedToDoubleFunction<T> mapToDoubleF) {
        return AggregateOperation.of(LongDoubleAccumulator::new, (a, i) -> {
            if (a.getValue1() == Long.MAX_VALUE) {
                throw new ArithmeticException("long overflow");
            }
            a.setValue1(a.getValue1() + 1L);
            a.setValue2(a.getValue2() + mapToDoubleF.applyAsDouble(i));
        }, (a1, a2) -> {
            a1.setValue1(Math.addExact(a1.getValue1(), a2.getValue1()));
            a1.setValue2(a1.getValue2() + a2.getValue2());
        }, (a1, a2) -> {
            a1.setValue1(Math.subtractExact(a1.getValue1(), a2.getValue1()));
            a1.setValue2(a1.getValue2() - a2.getValue2());
        }, a -> a.getValue2() / (double)a.getValue1());
    }

    @Nonnull
    public static <T> AggregateOperation<T, LinTrendAccumulator, Double> linearTrend(@Nonnull DistributedToLongFunction<T> getX, @Nonnull DistributedToLongFunction<T> getY) {
        return AggregateOperation.of(LinTrendAccumulator::new, (a, item) -> a.accumulate(getX.applyAsLong(item), getY.applyAsLong(item)), LinTrendAccumulator::combine, LinTrendAccumulator::deduct, LinTrendAccumulator::finish);
    }

    @SafeVarargs
    @Nonnull
    public static <T> AggregateOperation<T, List<Object>, List<Object>> allOf(AggregateOperation<? super T, ?, ?> ... operations) {
        AggregateOperation[] untypedOps = operations;
        return AggregateOperation.of(() -> {
            ArrayList res = new ArrayList(untypedOps.length);
            for (AggregateOperation untypedOp : untypedOps) {
                res.add(untypedOp.createAccumulatorF().get());
            }
            return res;
        }, (accs, item) -> {
            for (int i = 0; i < untypedOps.length; ++i) {
                untypedOps[i].accumulateItemF().accept(accs.get(i), item);
            }
        }, (accs1, accs2) -> {
            for (int i = 0; i < untypedOps.length; ++i) {
                untypedOps[i].combineAccumulatorsF().accept(accs1.get(i), accs2.get(i));
            }
        }, Stream.of(untypedOps).allMatch(o -> o.deductAccumulatorF() != null) ? (accs1, accs2) -> {
            for (int i = 0; i < untypedOps.length; ++i) {
                untypedOps[i].deductAccumulatorF().accept(accs1.get(i), accs2.get(i));
            }
        } : null, accs -> {
            ArrayList res = new ArrayList(untypedOps.length);
            for (int i = 0; i < untypedOps.length; ++i) {
                res.add(untypedOps[i].finishAccumulationF().apply(accs.get(i)));
            }
            return res;
        });
    }

    public static <T, U, A, R> AggregateOperation<T, ?, R> mapping(@Nonnull DistributedFunction<? super T, ? extends U> mapF, @Nonnull AggregateOperation<? super U, A, R> downstream) {
        DistributedBiConsumer downstreamAccumulateF = downstream.accumulateItemF();
        return AggregateOperation.of(downstream.createAccumulatorF(), (r, t) -> {
            Object mapped = mapF.apply(t);
            if (mapped != null) {
                downstreamAccumulateF.accept((Object)r, (Object)mapped);
            }
        }, downstream.combineAccumulatorsF(), downstream.deductAccumulatorF(), downstream.finishAccumulationF());
    }

    public static <T, C extends Collection<T>> AggregateOperation<T, C, C> toCollection(DistributedSupplier<C> createCollectionF) {
        return AggregateOperation.of(createCollectionF, Collection::add, Collection::addAll, null, DistributedFunction.identity());
    }

    public static <T> AggregateOperation<T, List<T>, List<T>> toList() {
        return AggregateOperations.toCollection(ArrayList::new);
    }

    public static <T> AggregateOperation<T, ?, Set<T>> toSet() {
        return AggregateOperations.toCollection(HashSet::new);
    }

    public static <T, K, U> AggregateOperation<T, Map<K, U>, Map<K, U>> toMap(DistributedFunction<? super T, ? extends K> getKeyF, DistributedFunction<? super T, ? extends U> getValueF) {
        return AggregateOperations.toMap(getKeyF, getValueF, AggregateOperations.throwingMerger(), HashMap::new);
    }

    public static <T, K, U> AggregateOperation<T, Map<K, U>, Map<K, U>> toMap(DistributedFunction<? super T, ? extends K> getKeyF, DistributedFunction<? super T, ? extends U> getValueF, DistributedBinaryOperator<U> mergeF) {
        return AggregateOperations.toMap(getKeyF, getValueF, mergeF, HashMap::new);
    }

    public static <T, K, U, M extends Map<K, U>> AggregateOperation<T, M, M> toMap(DistributedFunction<? super T, ? extends K> getKeyF, DistributedFunction<? super T, ? extends U> getValueF, DistributedBinaryOperator<U> mergeF, DistributedSupplier<M> createMapF) {
        DistributedBiConsumer<Map, Object> accumulateF = (map, element) -> map.merge(getKeyF.apply(element), getValueF.apply(element), mergeF);
        return AggregateOperation.of(createMapF, accumulateF, AggregateOperations.mapMerger(mergeF), null, DistributedFunction.identity());
    }

    private static <T> DistributedBinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException("Duplicate key: " + u);
        };
    }

    private static <K, V, M extends Map<K, V>> DistributedBiConsumer<M, M> mapMerger(DistributedBinaryOperator<V> mergeFunction) {
        return (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                m1.merge(e.getKey(), e.getValue(), mergeFunction);
            }
        };
    }

    @Nonnull
    public static <T, A> AggregateOperation<T, MutableReference<A>, A> reducing(@Nonnull A emptyAccValue, @Nonnull DistributedFunction<? super T, ? extends A> toAccValueF, @Nonnull DistributedBinaryOperator<A> combineAccValuesF, @Nullable DistributedBinaryOperator<A> deductAccValueF) {
        return AggregateOperation.of(() -> new MutableReference<Object>(emptyAccValue), (a, t) -> a.set(combineAccValuesF.apply(a.get(), toAccValueF.apply(t))), (a, b) -> a.set(combineAccValuesF.apply(a.get(), b.get())), deductAccValueF != null ? (a, b) -> a.set(deductAccValueF.apply(a.get(), b.get())) : null, MutableReference::get);
    }
}

