/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.AggregateOperationImpl;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface AggregateOperation<T, A, R>
extends Serializable {
    @Nonnull
    public DistributedSupplier<A> createAccumulatorF();

    @Nonnull
    public DistributedBiConsumer<? super A, T> accumulateItemF();

    @Nonnull
    public DistributedBiConsumer<? super A, ? super A> combineAccumulatorsF();

    @Nullable
    public DistributedBiConsumer<? super A, ? super A> deductAccumulatorF();

    @Nonnull
    public DistributedFunction<? super A, R> finishAccumulationF();

    default public <R1> AggregateOperation<T, A, R1> withFinish(@Nonnull DistributedFunction<? super A, R1> finishAccumulationF) {
        return AggregateOperation.of(this.createAccumulatorF(), this.accumulateItemF(), this.combineAccumulatorsF(), this.deductAccumulatorF(), finishAccumulationF);
    }

    default public <T1> AggregateOperation<T1, A, R> withAccumulate(@Nonnull DistributedBiConsumer<A, T1> accumulateItemF) {
        return AggregateOperation.of(this.createAccumulatorF(), accumulateItemF, this.combineAccumulatorsF(), this.deductAccumulatorF(), this.finishAccumulationF());
    }

    @Nonnull
    public static <T, A, R> AggregateOperation<T, A, R> of(@Nonnull DistributedSupplier<A> createAccumulatorF, @Nonnull DistributedBiConsumer<? super A, T> accumulateItemF, @Nonnull DistributedBiConsumer<? super A, ? super A> combineAccumulatorsF, @Nullable DistributedBiConsumer<? super A, ? super A> deductAccumulatorF, @Nonnull DistributedFunction<? super A, R> finishAccumulationF) {
        Objects.requireNonNull(createAccumulatorF);
        Objects.requireNonNull(accumulateItemF);
        Objects.requireNonNull(combineAccumulatorsF);
        Objects.requireNonNull(finishAccumulationF);
        return new AggregateOperationImpl<T, A, R>(createAccumulatorF, accumulateItemF, combineAccumulatorsF, deductAccumulatorF, finishAccumulationF);
    }
}

