/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.Inbox;
import com.hazelcast.jet.Outbox;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Watermark;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public abstract class AbstractProcessor
implements Processor {
    private boolean isCooperative = true;
    private ILogger logger;
    private Outbox outbox;
    private Object pendingItem;

    public final void setCooperative(boolean isCooperative) {
        this.isCooperative = isCooperative;
    }

    @Override
    public boolean isCooperative() {
        return this.isCooperative;
    }

    @Override
    public final void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) {
        this.outbox = outbox;
        this.logger = context.logger();
        try {
            this.init(context);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    protected void init(@Nonnull Processor.Context context) throws Exception {
    }

    protected final ILogger getLogger() {
        return this.logger;
    }

    @Override
    public final void process(int ordinal, @Nonnull Inbox inbox) {
        try {
            switch (ordinal) {
                case 0: {
                    this.process0(inbox);
                    return;
                }
                case 1: {
                    this.process1(inbox);
                    return;
                }
                case 2: {
                    this.process2(inbox);
                    return;
                }
                case 3: {
                    this.process3(inbox);
                    return;
                }
                case 4: {
                    this.process4(inbox);
                    return;
                }
            }
            this.processAny(ordinal, inbox);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    protected boolean tryProcess(int ordinal, @Nonnull Object item) throws Exception {
        throw new UnsupportedOperationException("Missing implementation");
    }

    protected boolean tryProcess0(@Nonnull Object item) throws Exception {
        return this.tryProcess(0, item);
    }

    protected boolean tryProcess1(@Nonnull Object item) throws Exception {
        return this.tryProcess(1, item);
    }

    protected boolean tryProcess2(@Nonnull Object item) throws Exception {
        return this.tryProcess(2, item);
    }

    protected boolean tryProcess3(@Nonnull Object item) throws Exception {
        return this.tryProcess(3, item);
    }

    protected boolean tryProcess4(@Nonnull Object item) throws Exception {
        return this.tryProcess(4, item);
    }

    protected boolean tryProcessWm(int ordinal, @Nonnull Watermark wm) {
        return this.tryEmit(wm);
    }

    protected boolean tryProcessWm0(@Nonnull Watermark wm) {
        return this.tryProcessWm(0, wm);
    }

    protected boolean tryProcessWm1(@Nonnull Watermark wm) {
        return this.tryProcessWm(1, wm);
    }

    protected boolean tryProcessWm2(@Nonnull Watermark wm) {
        return this.tryProcessWm(2, wm);
    }

    protected boolean tryProcessWm3(@Nonnull Watermark wm) {
        return this.tryProcessWm(3, wm);
    }

    protected boolean tryProcessWm4(@Nonnull Watermark wm) {
        return this.tryProcessWm(4, wm);
    }

    @CheckReturnValue
    protected boolean tryEmit(int ordinal, @Nonnull Object item) {
        return this.outbox.offer(ordinal, item);
    }

    @CheckReturnValue
    protected boolean tryEmit(@Nonnull Object item) {
        return this.outbox.offer(item);
    }

    @CheckReturnValue
    protected boolean tryEmit(int[] ordinals, @Nonnull Object item) {
        return this.outbox.offer(ordinals, item);
    }

    protected void emit(int ordinal, @Nonnull Object item) {
        AbstractProcessor.ensureAccepted(this.tryEmit(ordinal, item));
    }

    protected void emit(@Nonnull Object item) {
        AbstractProcessor.ensureAccepted(this.tryEmit(item));
    }

    protected void emit(int[] ordinals, @Nonnull Object item) {
        AbstractProcessor.ensureAccepted(this.tryEmit(ordinals, item));
    }

    private static void ensureAccepted(boolean accepted) {
        if (!accepted) {
            throw new IllegalStateException("Attempt to emit an item to a full outbox");
        }
    }

    protected boolean emitFromTraverser(int ordinal, @Nonnull Traverser<?> traverser) {
        Object item;
        if (this.pendingItem != null) {
            item = this.pendingItem;
            this.pendingItem = null;
        } else {
            item = traverser.next();
        }
        while (item != null) {
            if (!this.tryEmit(ordinal, item)) {
                this.pendingItem = item;
                return false;
            }
            item = traverser.next();
        }
        return true;
    }

    protected boolean emitFromTraverser(@Nonnull Traverser<?> traverser) {
        return this.emitFromTraverser(-1, traverser);
    }

    protected boolean emitFromTraverser(@Nonnull int[] ordinals, @Nonnull Traverser<?> traverser) {
        Object item;
        if (this.pendingItem != null) {
            item = this.pendingItem;
            this.pendingItem = null;
        } else {
            item = traverser.next();
        }
        while (item != null) {
            if (!this.tryEmit(ordinals, item)) {
                this.pendingItem = item;
                return false;
            }
            item = traverser.next();
        }
        return true;
    }

    @Nonnull
    protected <T, R> FlatMapper<T, R> flatMapper(int ordinal, @Nonnull Function<? super T, ? extends Traverser<? extends R>> mapper) {
        return ordinal != -1 ? this.flatMapper(new int[]{ordinal}, mapper) : this.flatMapper(mapper);
    }

    @Nonnull
    protected <T, R> FlatMapper<T, R> flatMapper(@Nonnull Function<? super T, ? extends Traverser<? extends R>> mapper) {
        return this.flatMapper(null, mapper);
    }

    @Nonnull
    protected <T, R> FlatMapper<T, R> flatMapper(int[] ordinals, @Nonnull Function<? super T, ? extends Traverser<? extends R>> mapper) {
        return new FlatMapper(ordinals, mapper);
    }

    protected void process0(@Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null) {
            boolean doneWithItem;
            boolean bl = doneWithItem = item instanceof Watermark ? this.tryProcessWm0((Watermark)item) : this.tryProcess0(item);
            if (!doneWithItem) {
                return;
            }
            inbox.remove();
        }
    }

    protected void process1(@Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null) {
            boolean doneWithItem;
            boolean bl = doneWithItem = item instanceof Watermark ? this.tryProcessWm1((Watermark)item) : this.tryProcess1(item);
            if (!doneWithItem) {
                return;
            }
            inbox.remove();
        }
    }

    protected void process2(@Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null) {
            boolean doneWithItem;
            boolean bl = doneWithItem = item instanceof Watermark ? this.tryProcessWm2((Watermark)item) : this.tryProcess2(item);
            if (!doneWithItem) {
                return;
            }
            inbox.remove();
        }
    }

    protected void process3(@Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null) {
            boolean doneWithItem;
            boolean bl = doneWithItem = item instanceof Watermark ? this.tryProcessWm3((Watermark)item) : this.tryProcess3(item);
            if (!doneWithItem) {
                return;
            }
            inbox.remove();
        }
    }

    protected void process4(@Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null) {
            boolean doneWithItem;
            boolean bl = doneWithItem = item instanceof Watermark ? this.tryProcessWm4((Watermark)item) : this.tryProcess4(item);
            if (!doneWithItem) {
                return;
            }
            inbox.remove();
        }
    }

    protected void processAny(int ordinal, @Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null) {
            boolean doneWithItem;
            boolean bl = doneWithItem = item instanceof Watermark ? this.tryProcessWm(ordinal, (Watermark)item) : this.tryProcess(ordinal, item);
            if (!doneWithItem) {
                return;
            }
            inbox.remove();
        }
    }

    protected final class FlatMapper<T, R> {
        private final int[] outputOrdinals;
        private final Function<? super T, ? extends Traverser<? extends R>> mapper;
        private Traverser<? extends R> outputTraverser;

        FlatMapper(@Nonnull int[] outputOrdinals, Function<? super T, ? extends Traverser<? extends R>> mapper) {
            this.outputOrdinals = outputOrdinals;
            this.mapper = mapper;
        }

        public boolean tryProcess(@Nonnull T item) {
            if (this.outputTraverser == null) {
                this.outputTraverser = this.mapper.apply(item);
            }
            if (this.emit()) {
                this.outputTraverser = null;
                return true;
            }
            return false;
        }

        private boolean emit() {
            return this.outputOrdinals != null ? AbstractProcessor.this.emitFromTraverser(this.outputOrdinals, this.outputTraverser) : AbstractProcessor.this.emitFromTraverser(this.outputTraverser);
        }
    }
}

