/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.invalidation;

import com.hazelcast.internal.nearcache.NearCacheRecord;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataContainer;
import com.hazelcast.internal.nearcache.impl.invalidation.MinimalPartitionService;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.internal.nearcache.impl.invalidation.StaleReadDetector;

public class StaleReadDetectorImpl
implements StaleReadDetector {
    private final RepairingHandler repairingHandler;
    private final MinimalPartitionService partitionService;

    public StaleReadDetectorImpl(RepairingHandler repairingHandler, MinimalPartitionService partitionService) {
        this.repairingHandler = repairingHandler;
        this.partitionService = partitionService;
    }

    @Override
    public boolean isStaleRead(Object key, NearCacheRecord record) {
        MetaDataContainer latestMetaData = this.repairingHandler.getMetaDataContainer(this.getPartition(key));
        if (!record.hasSameUuid(latestMetaData.getUuid())) {
            return true;
        }
        return record.getInvalidationSequence() < latestMetaData.getStaleSequence();
    }

    @Override
    public MetaDataContainer getMetaDataContainer(Object key) {
        return this.repairingHandler.getMetaDataContainer(this.getPartition(key));
    }

    private int getPartition(Object key) {
        return this.partitionService.getPartitionId(key);
    }
}

