/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.terminal;

import com.hazelcast.core.IList;
import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Distributed;
import com.hazelcast.jet.Edge;
import com.hazelcast.jet.Processors;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.processor.AnyMatchP;
import java.util.function.Predicate;

public class Matcher {
    private final StreamContext context;

    public Matcher(StreamContext context) {
        this.context = context;
    }

    public <T> boolean anyMatch(Pipeline<T> upstream, Distributed.Predicate<? super T> predicate) {
        return this.anyMatch(upstream, (Predicate<? super T>)predicate);
    }

    public <T> boolean anyMatch(Pipeline<T> upstream, Predicate<? super T> predicate) {
        StreamUtil.checkSerializable(predicate, "predicate");
        DAG dag = new DAG();
        Vertex anyMatch = dag.newVertex(StreamUtil.uniqueVertexName("any-match"), () -> new AnyMatchP(predicate));
        Vertex previous = upstream.buildDAG(dag);
        if (previous != anyMatch) {
            dag.edge(Edge.between(previous, anyMatch));
        }
        IList<Boolean> results = this.execute(dag, anyMatch);
        boolean result = Matcher.anyMatch(results);
        results.destroy();
        return result;
    }

    private static boolean anyMatch(IList<Boolean> results) {
        for (Boolean result : results) {
            if (!result.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private IList<Boolean> execute(DAG dag, Vertex vertex) {
        String listName = StreamUtil.uniqueListName();
        Vertex writer = dag.newVertex(StreamUtil.writerVertexName(listName), Processors.writeList(listName));
        dag.edge(Edge.between(vertex, writer));
        StreamUtil.executeJob(this.context, dag);
        return this.context.getJetInstance().getList(listName);
    }
}

