/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.processor;

import com.hazelcast.jet.AbstractProcessor;
import com.hazelcast.jet.stream.impl.pipeline.TransformOperation;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class TransformP
extends AbstractProcessor {
    private final TransformOperation[] operations;

    public TransformP(List<TransformOperation> operations) {
        this.operations = operations.toArray(new TransformOperation[operations.size()]);
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) throws Exception {
        this.processItem(item, 0);
        return true;
    }

    private void processItem(Object item, int operatorIndex) {
        block5: for (int i = operatorIndex; i < this.operations.length; ++i) {
            TransformOperation operation = this.operations[i];
            switch (operation.getType()) {
                case FILTER: {
                    if (((Predicate)operation.getFunction()).test(item)) continue block5;
                    return;
                }
                case MAP: {
                    item = ((Function)operation.getFunction()).apply(item);
                    continue block5;
                }
                case FLAT_MAP: {
                    Stream stream = (Stream)((Function)operation.getFunction()).apply(item);
                    Iterator iterator = stream.iterator();
                    while (iterator.hasNext()) {
                        this.processItem(iterator.next(), i + 1);
                    }
                    stream.close();
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unknown case: " + (Object)((Object)operation.getType()));
                }
            }
        }
        this.emit(item);
    }
}

