/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.pipeline;

import com.hazelcast.core.IList;
import com.hazelcast.jet.Distributed;
import com.hazelcast.jet.stream.DistributedCollectors;
import com.hazelcast.jet.stream.DistributedDoubleStream;
import com.hazelcast.jet.stream.DistributedIntStream;
import com.hazelcast.jet.stream.DistributedLongStream;
import com.hazelcast.jet.stream.DistributedStream;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.distributed.DistributedLongSummaryStatistics;
import com.hazelcast.jet.stream.impl.pipeline.DoublePipeline;
import com.hazelcast.jet.stream.impl.pipeline.IntPipeline;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.terminal.Reducer;
import java.util.Iterator;
import java.util.LongSummaryStatistics;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class LongPipeline
implements DistributedLongStream {
    private final StreamContext context;
    private final Pipeline<Long> inner;

    public LongPipeline(StreamContext context, Pipeline<Long> inner) {
        this.context = context;
        this.inner = inner;
    }

    @Override
    public DistributedLongStream filter(LongPredicate predicate) {
        StreamUtil.checkSerializable(predicate, "predicate");
        DistributedStream<Long> filter = this.inner.filter(predicate::test);
        return this.wrap(filter);
    }

    @Override
    public DistributedLongStream map(LongUnaryOperator mapper) {
        StreamUtil.checkSerializable(mapper, "mapper");
        DistributedStream<Long> map = this.inner.map(mapper::applyAsLong);
        return this.wrap(map);
    }

    @Override
    public <U> DistributedStream<U> mapToObj(LongFunction<? extends U> mapper) {
        StreamUtil.checkSerializable(mapper, "mapper");
        return this.inner.map(mapper::apply);
    }

    @Override
    public DistributedIntStream mapToInt(LongToIntFunction mapper) {
        StreamUtil.checkSerializable(mapper, "mapper");
        DistributedStream<Integer> stream = this.inner.map(mapper::applyAsInt);
        return new IntPipeline(this.context, (Pipeline)stream);
    }

    @Override
    public DistributedDoubleStream mapToDouble(LongToDoubleFunction mapper) {
        StreamUtil.checkSerializable(mapper, "mapper");
        DistributedStream<Double> stream = this.inner.map(mapper::applyAsDouble);
        return new DoublePipeline(this.context, (Pipeline)stream);
    }

    @Override
    public DistributedLongStream flatMap(LongFunction<? extends LongStream> mapper) {
        StreamUtil.checkSerializable(mapper, "mapper");
        return this.wrap(this.inner.flatMap((? super T n) -> ((LongStream)mapper.apply((long)n)).boxed()));
    }

    @Override
    public DistributedLongStream distinct() {
        return this.wrap(this.inner.distinct());
    }

    @Override
    public DistributedLongStream sorted() {
        return this.wrap(this.inner.sorted());
    }

    @Override
    public DistributedLongStream peek(LongConsumer action) {
        StreamUtil.checkSerializable(action, "action");
        return this.wrap(this.inner.peek(action::accept));
    }

    @Override
    public DistributedLongStream limit(long maxSize) {
        return this.wrap(this.inner.limit(maxSize));
    }

    @Override
    public DistributedLongStream skip(long n) {
        return this.wrap(this.inner.skip(n));
    }

    @Override
    public void forEach(LongConsumer action) {
        StreamUtil.checkSerializable(action, "action");
        this.inner.forEach(action::accept);
    }

    @Override
    public void forEachOrdered(LongConsumer action) {
        StreamUtil.checkSerializable(action, "action");
        this.inner.forEachOrdered(action::accept);
    }

    @Override
    public long[] toArray() {
        IList list = this.inner.collect(DistributedCollectors.toIList());
        long[] array = new long[list.size()];
        Iterator iterator = list.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            array[index++] = (Long)iterator.next();
        }
        return array;
    }

    @Override
    public long reduce(long identity, LongBinaryOperator op) {
        StreamUtil.checkSerializable(op, "op");
        return new Reducer(this.context).reduce(this.inner, Long.valueOf(identity), op::applyAsLong);
    }

    @Override
    public OptionalLong reduce(LongBinaryOperator op) {
        StreamUtil.checkSerializable(op, "op");
        Optional<Long> result = new Reducer(this.context).reduce(this.inner, op::applyAsLong);
        return result.isPresent() ? OptionalLong.of(result.get()) : OptionalLong.empty();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        StreamUtil.checkSerializable(accumulator, "accumulator");
        Distributed.BiConsumer<Object, Long> boxedAccumulator = accumulator::accept;
        return (R)this.inner.collect(supplier, boxedAccumulator, combiner);
    }

    @Override
    public long sum() {
        return this.inner.reduce(Long.valueOf(0L), (a, b) -> a + b);
    }

    @Override
    public OptionalLong min() {
        return LongPipeline.toOptionalLong(this.inner.min(Distributed.Comparator.naturalOrder()));
    }

    @Override
    public OptionalLong max() {
        return LongPipeline.toOptionalLong(this.inner.max(Distributed.Comparator.naturalOrder()));
    }

    @Override
    public long count() {
        return this.inner.count();
    }

    @Override
    public OptionalDouble average() {
        long[] avg = this.collect(() -> new long[2], (ll, i) -> {
            ll[0] = ll[0] + 1L;
            ll[1] = ll[1] + i;
        }, (R ll, R rr) -> {
            ll[0] = ll[0] + rr[0];
            ll[1] = ll[1] + rr[1];
        });
        return avg[0] > 0L ? OptionalDouble.of((double)avg[1] / (double)avg[0]) : OptionalDouble.empty();
    }

    @Override
    public LongSummaryStatistics summaryStatistics() {
        return this.collect(DistributedLongSummaryStatistics::new, LongSummaryStatistics::accept, LongSummaryStatistics::combine);
    }

    @Override
    public boolean anyMatch(LongPredicate predicate) {
        StreamUtil.checkSerializable(predicate, "predicate");
        return this.inner.anyMatch(predicate::test);
    }

    @Override
    public boolean allMatch(LongPredicate predicate) {
        StreamUtil.checkSerializable(predicate, "predicate");
        return this.inner.allMatch(predicate::test);
    }

    @Override
    public boolean noneMatch(LongPredicate predicate) {
        StreamUtil.checkSerializable(predicate, "predicate");
        return this.inner.noneMatch(predicate::test);
    }

    @Override
    public OptionalLong findFirst() {
        return LongPipeline.toOptionalLong(this.inner.findFirst());
    }

    @Override
    public OptionalLong findAny() {
        return LongPipeline.toOptionalLong(this.inner.findAny());
    }

    @Override
    public DistributedDoubleStream asDoubleStream() {
        return this.mapToDouble(m -> m);
    }

    @Override
    public DistributedStream<Long> boxed() {
        return this.inner;
    }

    @Override
    public DistributedLongStream sequential() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DistributedLongStream parallel() {
        return this;
    }

    @Override
    public DistributedLongStream unordered() {
        return this.wrap((Stream<Long>)this.inner.unordered());
    }

    @Override
    public DistributedLongStream onClose(Runnable closeHandler) {
        return this.wrap((Stream)this.inner.onClose(closeHandler));
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public PrimitiveIterator.OfLong iterator() {
        final Iterator iterator = this.inner.iterator();
        return new PrimitiveIterator.OfLong(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public long nextLong() {
                return (Long)iterator.next();
            }
        };
    }

    @Override
    public Spliterator.OfLong spliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isParallel() {
        return this.inner.isParallel();
    }

    private DistributedLongStream wrap(Stream<Long> pipeline) {
        return new LongPipeline(this.context, (Pipeline)pipeline);
    }

    private static OptionalLong toOptionalLong(Optional<Long> optional) {
        return optional.isPresent() ? OptionalLong.of(optional.get()) : OptionalLong.empty();
    }
}

