/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.pipeline;

import com.hazelcast.core.IList;
import com.hazelcast.jet.Distributed;
import com.hazelcast.jet.stream.DistributedCollectors;
import com.hazelcast.jet.stream.DistributedDoubleStream;
import com.hazelcast.jet.stream.DistributedIntStream;
import com.hazelcast.jet.stream.DistributedLongStream;
import com.hazelcast.jet.stream.DistributedStream;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.distributed.DistributedDoubleSummaryStatistics;
import com.hazelcast.jet.stream.impl.pipeline.IntPipeline;
import com.hazelcast.jet.stream.impl.pipeline.LongPipeline;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.terminal.Reducer;
import java.util.DoubleSummaryStatistics;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;

public class DoublePipeline
implements DistributedDoubleStream {
    private final StreamContext context;
    private final Pipeline<Double> inner;

    public DoublePipeline(StreamContext context, Pipeline<Double> inner) {
        this.context = context;
        this.inner = inner;
    }

    @Override
    public DistributedDoubleStream filter(DoublePredicate predicate) {
        StreamUtil.checkSerializable(predicate, "predicate");
        DistributedStream<Double> filter = this.inner.filter(predicate::test);
        return this.wrap(filter);
    }

    @Override
    public DistributedDoubleStream map(DoubleUnaryOperator mapper) {
        StreamUtil.checkSerializable(mapper, "mapper");
        DistributedStream<Double> map = this.inner.map(mapper::applyAsDouble);
        return this.wrap(map);
    }

    @Override
    public <U> DistributedStream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        StreamUtil.checkSerializable(mapper, "mapper");
        return this.inner.map(mapper::apply);
    }

    @Override
    public DistributedIntStream mapToInt(DoubleToIntFunction mapper) {
        StreamUtil.checkSerializable(mapper, "mapper");
        DistributedStream<Integer> stream = this.inner.map(mapper::applyAsInt);
        return new IntPipeline(this.context, (Pipeline)stream);
    }

    @Override
    public DistributedLongStream mapToLong(DoubleToLongFunction mapper) {
        StreamUtil.checkSerializable(mapper, "mapper");
        DistributedStream<Long> stream = this.inner.map(mapper::applyAsLong);
        return new LongPipeline(this.context, (Pipeline)stream);
    }

    @Override
    public DistributedDoubleStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        StreamUtil.checkSerializable(mapper, "mapper");
        return this.wrap(this.inner.flatMap((? super T n) -> ((DoubleStream)mapper.apply((double)n)).boxed()));
    }

    @Override
    public DistributedDoubleStream distinct() {
        return this.wrap(this.inner.distinct());
    }

    @Override
    public DistributedDoubleStream sorted() {
        return this.wrap(this.inner.sorted());
    }

    @Override
    public DistributedDoubleStream peek(DoubleConsumer action) {
        StreamUtil.checkSerializable(action, "action");
        return this.wrap(this.inner.peek(action::accept));
    }

    @Override
    public DistributedDoubleStream limit(long maxSize) {
        return this.wrap(this.inner.limit(maxSize));
    }

    @Override
    public DistributedDoubleStream skip(long n) {
        return this.wrap(this.inner.skip(n));
    }

    @Override
    public void forEach(DoubleConsumer action) {
        this.inner.forEach(action::accept);
    }

    @Override
    public void forEachOrdered(DoubleConsumer action) {
        StreamUtil.checkSerializable(action, "action");
        this.inner.forEachOrdered(action::accept);
    }

    @Override
    public double[] toArray() {
        IList list = this.inner.collect(DistributedCollectors.toIList());
        double[] array = new double[list.size()];
        Iterator iterator = list.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            array[index++] = (Double)iterator.next();
        }
        return array;
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator op) {
        StreamUtil.checkSerializable(op, "op");
        return new Reducer(this.context).reduce(this.inner, Double.valueOf(identity), op::applyAsDouble);
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator op) {
        StreamUtil.checkSerializable(op, "op");
        Optional<Double> result = new Reducer(this.context).reduce(this.inner, op::applyAsDouble);
        return result.isPresent() ? OptionalDouble.of(result.get()) : OptionalDouble.empty();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        StreamUtil.checkSerializable(accumulator, "accumulator");
        Distributed.BiConsumer<Object, Double> boxedAccumulator = accumulator::accept;
        return (R)this.inner.collect(supplier, boxedAccumulator, combiner);
    }

    @Override
    public double sum() {
        return this.inner.reduce(Double.valueOf(0.0), (a, b) -> a + b);
    }

    @Override
    public OptionalDouble min() {
        return DoublePipeline.toOptionalDouble(this.inner.min(Distributed.Comparator.naturalOrder()));
    }

    @Override
    public OptionalDouble max() {
        return DoublePipeline.toOptionalDouble(this.inner.max(Distributed.Comparator.naturalOrder()));
    }

    @Override
    public long count() {
        return this.inner.count();
    }

    @Override
    public OptionalDouble average() {
        double[] avg = this.collect(() -> new double[2], (ll, i) -> {
            ll[0] = ll[0] + 1.0;
            ll[1] = ll[1] + i;
        }, (R ll, R rr) -> {
            ll[0] = ll[0] + rr[0];
            ll[1] = ll[1] + rr[1];
        });
        return avg[0] > 0.0 ? OptionalDouble.of(avg[1] / avg[0]) : OptionalDouble.empty();
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        return this.collect(DistributedDoubleSummaryStatistics::new, DoubleSummaryStatistics::accept, DoubleSummaryStatistics::combine);
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        StreamUtil.checkSerializable(predicate, "predicate");
        return this.inner.anyMatch(predicate::test);
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        StreamUtil.checkSerializable(predicate, "predicate");
        return this.inner.allMatch(predicate::test);
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        StreamUtil.checkSerializable(predicate, "predicate");
        return this.inner.noneMatch(predicate::test);
    }

    @Override
    public OptionalDouble findFirst() {
        return DoublePipeline.toOptionalDouble(this.inner.findFirst());
    }

    @Override
    public OptionalDouble findAny() {
        return DoublePipeline.toOptionalDouble(this.inner.findAny());
    }

    @Override
    public DistributedStream<Double> boxed() {
        return this.inner;
    }

    @Override
    public DistributedDoubleStream sequential() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DistributedDoubleStream parallel() {
        return this;
    }

    @Override
    public DistributedDoubleStream unordered() {
        return this.wrap((Stream<Double>)this.inner.unordered());
    }

    @Override
    public DistributedDoubleStream onClose(Runnable closeHandler) {
        return this.wrap((Stream)this.inner.onClose(closeHandler));
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        final Iterator iterator = this.inner.iterator();
        return new PrimitiveIterator.OfDouble(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public double nextDouble() {
                return (Double)iterator.next();
            }
        };
    }

    @Override
    public Spliterator.OfDouble spliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isParallel() {
        return this.inner.isParallel();
    }

    private DistributedDoubleStream wrap(Stream<Double> pipeline) {
        return new DoublePipeline(this.context, (Pipeline)pipeline);
    }

    private static OptionalDouble toOptionalDouble(Optional<Double> optional) {
        return optional.isPresent() ? OptionalDouble.of(optional.get()) : OptionalDouble.empty();
    }
}

