/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.collectors;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.ProcessorMetaSupplier;
import com.hazelcast.jet.Processors;
import com.hazelcast.jet.stream.IStreamList;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.collectors.AbstractHazelcastCollector;

public class HazelcastListCollector<T>
extends AbstractHazelcastCollector<T, IStreamList<T>> {
    private final String listName;

    public HazelcastListCollector() {
        this(StreamUtil.uniqueListName());
    }

    public HazelcastListCollector(String listName) {
        this.listName = listName;
    }

    @Override
    protected IStreamList<T> getTarget(JetInstance instance) {
        return instance.getList(this.listName);
    }

    @Override
    protected ProcessorMetaSupplier getConsumer() {
        return ProcessorMetaSupplier.of(Processors.writeList(this.listName));
    }

    @Override
    protected int localParallelism() {
        return 1;
    }

    @Override
    protected String getName() {
        return this.listName;
    }
}

