/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream;

import com.hazelcast.jet.Distributed;
import com.hazelcast.jet.stream.DistributedCollectors;
import com.hazelcast.jet.stream.impl.collectors.DistributedCollectorImpl;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;

public interface DistributedCollector<T, A, R>
extends Collector<T, A, R>,
Serializable {
    @Override
    public Distributed.Supplier<A> supplier();

    @Override
    public Distributed.BiConsumer<A, T> accumulator();

    @Override
    public Distributed.BinaryOperator<A> combiner();

    @Override
    public Distributed.Function<A, R> finisher();

    public static <T, R> DistributedCollector<T, R, R> of(Distributed.Supplier<R> supplier, Distributed.BiConsumer<R, T> accumulator, Distributed.BinaryOperator<R> combiner, Collector.Characteristics ... characteristics) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        Objects.requireNonNull(characteristics);
        Set<Collector.Characteristics> cs = characteristics.length == 0 ? DistributedCollectors.CH_ID : Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH, characteristics));
        return new DistributedCollectorImpl(supplier, accumulator, combiner, cs);
    }

    public static <T, A, R> DistributedCollector<T, A, R> of(Distributed.Supplier<A> supplier, Distributed.BiConsumer<A, T> accumulator, Distributed.BinaryOperator<A> combiner, Distributed.Function<A, R> finisher, Collector.Characteristics ... characteristics) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        Objects.requireNonNull(finisher);
        Objects.requireNonNull(characteristics);
        Set<Collector.Characteristics> cs = DistributedCollectors.CH_NOID;
        if (characteristics.length > 0) {
            cs = EnumSet.noneOf(Collector.Characteristics.class);
            Collections.addAll(cs, characteristics);
            cs = Collections.unmodifiableSet(cs);
        }
        return new DistributedCollectorImpl<T, A, R>(supplier, accumulator, combiner, finisher, cs);
    }

    public R collect(StreamContext var1, Pipeline<? extends T> var2);
}

