/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.client.impl.protocol.ClientExceptionFactory;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.TopologyChangedException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static void registerJetExceptions(@Nonnull ClientExceptionFactory factory) {
        factory.register(500, JetException.class, JetException::new);
        factory.register(501, TopologyChangedException.class, TopologyChangedException::new);
    }

    @Nullable
    public static Throwable peel(@Nullable Throwable t) {
        if (t instanceof CompletionException || t instanceof ExecutionException || t instanceof InvocationTargetException) {
            Throwable cause = t.getCause();
            if (cause != null) {
                return ExceptionUtil.peel(cause);
            }
            return t;
        }
        return t;
    }

    @Nonnull
    private static RuntimeException peeledAndUnchecked(@Nonnull Throwable t) {
        if ((t = ExceptionUtil.peel(t)) instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new JetException(t);
    }

    @Nonnull
    public static RuntimeException rethrow(@Nonnull Throwable t) {
        if (t instanceof Error) {
            if (t instanceof OutOfMemoryError) {
                OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)((OutOfMemoryError)t));
            }
            throw (Error)t;
        }
        throw ExceptionUtil.peeledAndUnchecked(t);
    }

    @Nonnull
    public static <T extends Throwable> RuntimeException sneakyThrow(@Nonnull Throwable t) throws T {
        throw t;
    }
}

