/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.execution.init.EdgeDef;
import com.hazelcast.jet.impl.execution.init.JetImplDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class VertexDef
implements IdentifiedDataSerializable {
    private int id;
    private List<EdgeDef> inboundEdges = new ArrayList<EdgeDef>();
    private List<EdgeDef> outboundEdges = new ArrayList<EdgeDef>();
    private String name;
    private ProcessorSupplier processorSupplier;
    private int parallelism;

    VertexDef() {
    }

    public VertexDef(int id, String name, ProcessorSupplier processorSupplier, int parallelism) {
        this.id = id;
        this.name = name;
        this.processorSupplier = processorSupplier;
        this.parallelism = parallelism;
    }

    public int vertexId() {
        return this.id;
    }

    public void addInboundEdges(List<EdgeDef> edges) {
        this.inboundEdges.addAll(edges);
    }

    public void addOutboundEdges(List<EdgeDef> edges) {
        this.outboundEdges.addAll(edges);
    }

    public List<EdgeDef> inboundEdges() {
        return this.inboundEdges;
    }

    public List<EdgeDef> outboundEdges() {
        return this.outboundEdges;
    }

    public ProcessorSupplier processorSupplier() {
        return this.processorSupplier;
    }

    public String name() {
        return this.name;
    }

    public int parallelism() {
        return this.parallelism;
    }

    public int getFactoryId() {
        return JetImplDataSerializerHook.FACTORY_ID;
    }

    public int getId() {
        return 1;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeUTF(this.name);
        Util.writeList(out, this.inboundEdges);
        Util.writeList(out, this.outboundEdges);
        CustomClassLoadedObject.write(out, this.processorSupplier);
        out.writeInt(this.parallelism);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.id = in.readInt();
        this.name = in.readUTF();
        this.inboundEdges = Util.readList(in);
        this.outboundEdges = Util.readList(in);
        this.processorSupplier = (ProcessorSupplier)CustomClassLoadedObject.read(in);
        this.parallelism = in.readInt();
    }
}

