/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.jet.Partitioner;
import com.hazelcast.jet.impl.execution.init.EdgeDef;
import com.hazelcast.jet.impl.util.CircularListCursor;
import com.hazelcast.jet.impl.util.ProgressState;
import com.hazelcast.jet.impl.util.ProgressTracker;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.BitSet;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public interface OutboundCollector {
    public ProgressState offer(Object var1);

    default public ProgressState offer(Object item, int partitionId) {
        return this.offer(item);
    }

    public ProgressState close();

    public int[] getPartitions();

    public static OutboundCollector compositeCollector(OutboundCollector[] collectors, EdgeDef outboundEdge, int partitionCount) {
        switch (outboundEdge.forwardingPattern()) {
            case VARIABLE_UNICAST: {
                return new RoundRobin(collectors);
            }
            case PARTITIONED: {
                return new Partitioned(collectors, outboundEdge.partitioner(), partitionCount);
            }
            case BROADCAST: {
                return new Broadcast(collectors);
            }
        }
        throw new AssertionError((Object)("Missing case label for " + outboundEdge.forwardingPattern()));
    }

    public static class Partitioned
    extends Composite {
        private final Partitioner partitioner;
        private final OutboundCollector[] partitionLookupTable;
        private int partitionId = -1;

        Partitioned(OutboundCollector[] collectors, Partitioner partitioner, int partitionCount) {
            super(collectors);
            this.partitioner = partitioner;
            this.partitionLookupTable = new OutboundCollector[partitionCount];
            for (OutboundCollector collector : collectors) {
                for (int partitionId : collector.getPartitions()) {
                    this.partitionLookupTable[partitionId] = collector;
                }
            }
        }

        @Override
        public ProgressState offer(Object item) {
            ProgressState result;
            if (this.partitionId == -1) {
                this.partitionId = this.partitioner.getPartition(item, this.partitionLookupTable.length);
                assert (this.partitionId >= 0 && this.partitionId < this.partitionLookupTable.length) : "Partition number out of range: " + this.partitionId + ", offending item: " + item;
            }
            if ((result = this.offer(item, this.partitionId)).isDone()) {
                this.partitionId = -1;
            }
            return result;
        }

        @Override
        public ProgressState offer(Object item, int partitionId) {
            OutboundCollector collector = this.partitionLookupTable[partitionId];
            assert (collector != null) : "This item should not be handled by this collector as requested partitionId is not present";
            return collector.offer(item, partitionId);
        }
    }

    public static class Broadcast
    extends Composite {
        private final ProgressTracker progTracker = new ProgressTracker();
        private final BitSet isItemSentTo;

        Broadcast(OutboundCollector[] collectors) {
            super(collectors);
            this.isItemSentTo = new BitSet(collectors.length);
        }

        @Override
        public ProgressState offer(Object item) {
            this.progTracker.reset();
            for (int i = 0; i < this.collectors.length; ++i) {
                if (this.isItemSentTo.get(i)) continue;
                ProgressState result = this.collectors[i].offer(item);
                this.progTracker.mergeWith(result);
                if (!result.isDone()) continue;
                this.isItemSentTo.set(i);
            }
            if (this.progTracker.isDone()) {
                this.isItemSentTo.clear();
            }
            return this.progTracker.toProgressState();
        }
    }

    public static class RoundRobin
    extends Composite {
        private final CircularListCursor<OutboundCollector> cursor;

        RoundRobin(OutboundCollector[] collectors) {
            super(collectors);
            this.cursor = new CircularListCursor<OutboundCollector>(Arrays.asList(collectors));
        }

        @Override
        public ProgressState offer(Object item) {
            ProgressState result;
            OutboundCollector first = this.cursor.value();
            do {
                if ((result = this.cursor.value().offer(item)).isDone()) {
                    this.cursor.advance();
                    return result;
                }
                if (result.isMadeProgress()) {
                    return result;
                }
                this.cursor.advance();
            } while (this.cursor.value() != first);
            return result;
        }
    }

    public static abstract class Composite
    implements OutboundCollector {
        protected final OutboundCollector[] collectors;
        protected final ProgressTracker progTracker = new ProgressTracker();
        protected final int[] partitions;

        Composite(OutboundCollector[] collectors) {
            this.collectors = collectors;
            this.partitions = Stream.of(collectors).flatMapToInt(c -> IntStream.of(c.getPartitions())).sorted().toArray();
        }

        @Override
        public ProgressState close() {
            this.progTracker.reset();
            for (int i = 0; i < this.collectors.length; ++i) {
                if (this.collectors[i] == null) continue;
                ProgressState result = this.collectors[i].close();
                this.progTracker.mergeWith(result);
                if (!result.isDone()) continue;
                this.collectors[i] = null;
            }
            return this.progTracker.toProgressState();
        }

        @Override
        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public int[] getPartitions() {
            return this.partitions;
        }
    }
}

