/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.deployment;

import com.hazelcast.jet.impl.SerializationConstants;
import com.hazelcast.jet.impl.deployment.ResourceDescriptor;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;

public class ResourcePart
implements IdentifiedDataSerializable {
    private byte[] bytes;
    private ResourceDescriptor descriptor;
    private int offset;

    public ResourcePart() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public ResourcePart(ResourceDescriptor descriptor, byte[] bytes, int offset) {
        this.bytes = bytes;
        this.descriptor = descriptor;
        this.offset = offset;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getBytes() {
        return this.bytes;
    }

    public ResourceDescriptor getDescriptor() {
        return this.descriptor;
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        return "Chunk{length=" + this.bytes.length + ", descriptor=" + this.descriptor + ", offset=" + this.offset + '}';
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.descriptor);
        out.writeByteArray(this.bytes);
        out.writeInt(this.offset);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.descriptor = (ResourceDescriptor)in.readObject();
        this.bytes = in.readByteArray();
        this.offset = in.readInt();
    }

    public int getFactoryId() {
        return SerializationConstants.FACTORY_ID;
    }

    public int getId() {
        return 3;
    }
}

