/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.jet.impl.util.ExceptionUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class InstanceConfig {
    public static final int DEFAULT_FLOW_CONTROL_PERIOD_MS = 100;
    private int cooperativeThreadCount = Runtime.getRuntime().availableProcessors();
    private int flowControlPeriodMs = 100;
    private String tempDir;

    public InstanceConfig setCooperativeThreadCount(int size) {
        this.cooperativeThreadCount = size;
        return this;
    }

    public int getCooperativeThreadCount() {
        return this.cooperativeThreadCount;
    }

    public InstanceConfig setTempDir(String tempDir) {
        this.tempDir = tempDir;
        return this;
    }

    public String getTempDir() {
        if (this.tempDir == null) {
            try {
                Path tempDirectory = Files.createTempDirectory("hazelcast-jet", new FileAttribute[0]);
                tempDirectory.toFile().deleteOnExit();
                this.tempDir = tempDirectory.toString();
            }
            catch (IOException e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        return this.tempDir;
    }

    public InstanceConfig setFlowControlPeriodMs(int flowControlPeriodMs) {
        this.flowControlPeriodMs = flowControlPeriodMs;
        return this;
    }

    public int getFlowControlPeriodMs() {
        return this.flowControlPeriodMs;
    }
}

