/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.processor;

import com.hazelcast.jet.AbstractProcessor;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class MergeP<T, K, V>
extends AbstractProcessor {
    private final Function<? super T, ? extends K> keyMapper;
    private final Function<? super T, ? extends V> valueMapper;
    private final BinaryOperator<V> merger;
    private final Map<K, V> merged = new HashMap();
    private final Traverser<Map.Entry<K, V>> resultTraverser;

    public MergeP(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, BinaryOperator<V> merger) {
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
        this.merger = merger;
        this.resultTraverser = Traversers.lazy(() -> Traversers.traverseStream(this.merged.entrySet().stream().map(item -> Util.entry(item.getKey(), item.getValue()))));
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) throws Exception {
        Map.Entry<K, V> entry = this.keyMapper == null || this.valueMapper == null ? (Map.Entry<K, V>)item : Util.entry(this.keyMapper.apply(item), this.valueMapper.apply(item));
        V value = this.merged.get(entry.getKey());
        if (value == null) {
            this.merged.put(entry.getKey(), entry.getValue());
        } else {
            this.merged.put(entry.getKey(), this.merger.apply(value, entry.getValue()));
        }
        return true;
    }

    @Override
    public boolean complete() {
        return this.emitCooperatively(this.resultTraverser);
    }
}

