/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.pipeline;

import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Edge;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.AbstractIntermediatePipeline;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.processor.SkipP;

class SkipPipeline<T>
extends AbstractIntermediatePipeline<T, T> {
    private final long skip;

    SkipPipeline(StreamContext context, Pipeline<T> upstream, long skip) {
        super(context, upstream.isOrdered(), upstream);
        this.skip = skip;
    }

    @Override
    public Vertex buildDAG(DAG dag) {
        Vertex previous = this.upstream.buildDAG(dag);
        long skip = this.skip;
        Vertex skipVertex = dag.newVertex(StreamUtil.uniqueVertexName("skip"), () -> new SkipP(skip)).localParallelism(1);
        Edge edge = Edge.between(previous, skipVertex);
        if (!this.upstream.isOrdered()) {
            edge = edge.distributed().allToOne();
        }
        dag.edge(edge);
        return skipVertex;
    }
}

