/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.distributed;

import com.hazelcast.jet.Distributed;
import java.util.Comparator;
import java.util.Objects;

public final class DistributedComparators {
    public static final Distributed.Comparator<Comparable<Object>> NATURAL_ORDER_COMPARATOR = new NaturalOrderComparator();
    public static final Distributed.Comparator<Comparable<Object>> REVERSE_ORDER_COMPARATOR = new ReverseOrderComparator();

    private DistributedComparators() {
    }

    public static final class NullComparator<T>
    implements Distributed.Comparator<T> {
        private static final long serialVersionUID = -7569533591570686392L;
        private final boolean nullFirst;
        private final Comparator<T> real;

        public NullComparator(boolean nullFirst, Comparator<? super T> real) {
            this.nullFirst = nullFirst;
            this.real = real;
        }

        @Override
        public int compare(T a, T b) {
            if (a == null) {
                return b == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b == null) {
                return this.nullFirst ? 1 : -1;
            }
            return this.real == null ? 0 : this.real.compare(a, b);
        }

        @Override
        public Distributed.Comparator<T> thenComparing(Comparator<? super T> other) {
            Objects.requireNonNull(other);
            return new NullComparator<T>(this.nullFirst, this.real == null ? other : this.real.thenComparing(other));
        }

        @Override
        public Distributed.Comparator<T> reversed() {
            return new NullComparator<T>(!this.nullFirst, this.real == null ? null : this.real.reversed());
        }
    }

    private static class ReverseOrderComparator
    implements Distributed.Comparator<Comparable<Object>> {
        private ReverseOrderComparator() {
        }

        @Override
        public int compare(Comparable<Object> c1, Comparable<Object> c2) {
            return c2.compareTo(c1);
        }

        @Override
        public Distributed.Comparator<Comparable<Object>> reversed() {
            return NATURAL_ORDER_COMPARATOR;
        }
    }

    private static class NaturalOrderComparator
    implements Distributed.Comparator<Comparable<Object>> {
        private NaturalOrderComparator() {
        }

        @Override
        public int compare(Comparable<Object> c1, Comparable<Object> c2) {
            return c1.compareTo(c2);
        }

        @Override
        public Distributed.Comparator<Comparable<Object>> reversed() {
            return REVERSE_ORDER_COMPARATOR;
        }
    }
}

