/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import java.io.IOException;

class CompleteOperation
extends Operation {
    private long executionId;
    private Throwable error;

    CompleteOperation(long executionId, Throwable error) {
        this.executionId = executionId;
        this.error = error;
    }

    private CompleteOperation() {
    }

    public void run() throws Exception {
        this.getLogger().fine("Completing execution of plan for job " + this.executionId + ".");
        JetService service = (JetService)this.getService();
        service.completeExecution(this.executionId, this.error);
        this.getLogger().fine("Completed execution of plan for job " + this.executionId + ".");
    }

    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
        out.writeObject((Object)this.error);
    }

    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
        this.error = (Throwable)in.readObject();
    }
}

