/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.jet.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.Map;

public final class JetSerializerHook {
    public static final int JET_RESERVED_SPACE_START = -300;
    public static final int MAP_ENTRY = -300;
    public static final int CUSTOM_CLASS_LOADED_OBJECT = -301;
    public static final int OBJECT_ARRAY = -302;
    public static final int JET_RESERVED_SPACE_END = -399;

    private JetSerializerHook() {
    }

    public static final class MapEntry
    implements SerializerHook<Map.Entry> {
        public Class<Map.Entry> getSerializationType() {
            return Map.Entry.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<Map.Entry>(){

                public int getTypeId() {
                    return -300;
                }

                public void destroy() {
                }

                public void write(ObjectDataOutput out, Map.Entry object) throws IOException {
                    out.writeObject(object.getKey());
                    out.writeObject(object.getValue());
                }

                public Map.Entry read(ObjectDataInput in) throws IOException {
                    return Util.entry(in.readObject(), in.readObject());
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class ObjectArray
    implements SerializerHook<Object[]> {
        public Class<Object[]> getSerializationType() {
            return Object[].class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<Object[]>(){

                public int getTypeId() {
                    return -302;
                }

                public void destroy() {
                }

                public void write(ObjectDataOutput out, Object[] array) throws IOException {
                    out.writeInt(array.length);
                    for (int i = 0; i < array.length; ++i) {
                        out.writeObject(array[i]);
                    }
                }

                public Object[] read(ObjectDataInput in) throws IOException {
                    int length = in.readInt();
                    Object[] array = new Object[length];
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = in.readObject();
                    }
                    return array;
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }
}

