/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.jet.Edge;
import com.hazelcast.jet.Partitioner;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.execution.init.JetImplDataSerializerHook;
import com.hazelcast.jet.impl.execution.init.VertexDef;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Map;

public class EdgeDef
implements IdentifiedDataSerializable {
    private int oppositeVertexId;
    private int sourceOrdinal;
    private int destOrdinal;
    private int priority;
    private boolean isBuffered;
    private boolean isDistributed;
    private Edge.ForwardingPattern forwardingPattern;
    private Partitioner partitioner;
    private EdgeConfig config;
    private transient String id;
    private transient VertexDef sourceVertex;
    private transient VertexDef destVertex;

    EdgeDef() {
    }

    EdgeDef(Edge edge, EdgeConfig config, int oppositeVertexId, boolean isJobDistributed) {
        this.oppositeVertexId = oppositeVertexId;
        this.sourceOrdinal = edge.getSourceOrdinal();
        this.destOrdinal = edge.getDestOrdinal();
        this.priority = edge.getPriority();
        this.isBuffered = edge.isBuffered();
        this.isDistributed = isJobDistributed && edge.isDistributed();
        this.forwardingPattern = edge.getForwardingPattern();
        this.partitioner = edge.getPartitioner();
        this.config = config;
    }

    void initTransientFields(Map<Integer, VertexDef> vMap, VertexDef nearVertex, boolean isOutbound) {
        VertexDef farVertex = vMap.get(this.oppositeVertexId);
        this.sourceVertex = isOutbound ? nearVertex : farVertex;
        this.destVertex = isOutbound ? farVertex : nearVertex;
        this.id = this.sourceVertex.vertexId() + ":" + this.destVertex.vertexId();
    }

    public Edge.ForwardingPattern forwardingPattern() {
        return this.forwardingPattern;
    }

    public Partitioner partitioner() {
        return this.partitioner;
    }

    String edgeId() {
        return this.id;
    }

    VertexDef sourceVertex() {
        return this.sourceVertex;
    }

    int sourceOrdinal() {
        return this.sourceOrdinal;
    }

    VertexDef destVertex() {
        return this.destVertex;
    }

    int destOrdinal() {
        return this.destOrdinal;
    }

    int priority() {
        return this.priority;
    }

    boolean isBuffered() {
        return this.isBuffered;
    }

    boolean isDistributed() {
        return this.isDistributed;
    }

    EdgeConfig getConfig() {
        return this.config;
    }

    public int getFactoryId() {
        return JetImplDataSerializerHook.FACTORY_ID;
    }

    public int getId() {
        return 2;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.oppositeVertexId);
        out.writeInt(this.destOrdinal);
        out.writeInt(this.sourceOrdinal);
        out.writeInt(this.priority);
        out.writeBoolean(this.isBuffered);
        out.writeBoolean(this.isDistributed);
        out.writeObject((Object)this.forwardingPattern);
        CustomClassLoadedObject.write(out, this.partitioner);
        out.writeObject((Object)this.config);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.oppositeVertexId = in.readInt();
        this.destOrdinal = in.readInt();
        this.sourceOrdinal = in.readInt();
        this.priority = in.readInt();
        this.isBuffered = in.readBoolean();
        this.isDistributed = in.readBoolean();
        this.forwardingPattern = (Edge.ForwardingPattern)in.readObject();
        this.partitioner = (Partitioner)CustomClassLoadedObject.read(in);
        this.config = (EdgeConfig)in.readObject();
    }
}

