/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.deployment;

import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.impl.deployment.ResourcePart;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class ResourceIterator
implements Iterator<ResourcePart> {
    private final int partSize;
    private final Iterator<ResourceConfig> configIterator;
    private InputStream inputStream;
    private ResourceConfig resourceConfig;
    private int offset;

    public ResourceIterator(Set<ResourceConfig> resourceConfigs, int partSize) {
        this.configIterator = resourceConfigs.iterator();
        this.partSize = partSize;
    }

    private void switchFile() throws IOException {
        if (!this.configIterator.hasNext()) {
            throw new NoSuchElementException();
        }
        this.resourceConfig = this.configIterator.next();
        this.inputStream = this.resourceConfig.getUrl().openStream();
        this.offset = 0;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.configIterator.hasNext() || this.inputStream != null && this.inputStream.available() > 0;
        }
        catch (IOException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResourcePart next() {
        try {
            if (this.inputStream == null) {
                this.switchFile();
            }
            byte[] bytes = Util.read(this.inputStream, this.partSize);
            if (this.inputStream.available() <= 0) {
                ResourceIterator.close(this.inputStream);
                this.inputStream = null;
            }
            if (bytes.length > 0) {
                ResourcePart part = new ResourcePart(this.resourceConfig.getDescriptor(), bytes, this.offset);
                this.offset += bytes.length;
                return part;
            }
            throw new NoSuchElementException();
        }
        catch (IOException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private static void close(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            inputStream.close();
        }
    }
}

