/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Partition;
import com.hazelcast.jet.AbstractProcessor;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.ProcessorMetaSupplier;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.Processors;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.impl.connector.SerializableClientConfig;
import com.hazelcast.jet.impl.util.CircularListCursor;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.nio.Address;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public final class ReadIMapP
extends AbstractProcessor {
    private static final int DEFAULT_FETCH_SIZE = 16384;
    private final Traverser<Map.Entry> outputTraverser;

    ReadIMapP(Function<Integer, Iterator<Map.Entry>> partitionToIterator, List<Integer> partitions) {
        CircularListCursor iteratorCursor = new CircularListCursor(partitions.stream().map(partitionToIterator).collect(Collectors.toList()));
        this.outputTraverser = () -> {
            do {
                Iterator currIterator;
                if ((currIterator = (Iterator)iteratorCursor.value()).hasNext()) {
                    iteratorCursor.advance();
                    return (Map.Entry)currIterator.next();
                }
                iteratorCursor.remove();
            } while (iteratorCursor.advance());
            return null;
        };
    }

    @Override
    public boolean complete() {
        return this.emitCooperatively(this.outputTraverser);
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    public static ProcessorMetaSupplier supplier(String mapName) {
        return new LocalClusterMetaSupplier(mapName, 16384);
    }

    public static ProcessorMetaSupplier supplier(String mapName, int fetchSize) {
        return new LocalClusterMetaSupplier(mapName, fetchSize);
    }

    public static ProcessorMetaSupplier supplier(String mapName, int fetchSize, ClientConfig clientConfig) {
        return new RemoteClusterMetaSupplier(mapName, fetchSize, clientConfig);
    }

    public static ProcessorMetaSupplier supplier(String mapName, ClientConfig clientConfig) {
        return new RemoteClusterMetaSupplier(mapName, 16384, clientConfig);
    }

    static List<Processor> getProcessors(int count, List<Integer> ownedPartitions, Function<Integer, Iterator<Map.Entry>> partitionToIterator) {
        Map processorToPartitions = IntStream.range(0, ownedPartitions.size()).mapToObj(i -> Util.entry(i, ownedPartitions.get(i))).collect(Collectors.groupingBy(e -> (Integer)e.getKey() % count, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        IntStream.range(0, count).forEach(processor -> processorToPartitions.computeIfAbsent(processor, x -> Collections.emptyList()));
        return processorToPartitions.values().stream().map(partitions -> !partitions.isEmpty() ? new ReadIMapP(partitionToIterator, (List<Integer>)partitions) : new Processors.NoopP()).collect(Collectors.toList());
    }

    private static class LocalClusterProcessorSupplier
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final String mapName;
        private final List<Integer> ownedPartitions;
        private final int fetchSize;
        private transient MapProxyImpl map;

        LocalClusterProcessorSupplier(String mapName, List<Integer> ownedPartitions, int fetchSize) {
            this.mapName = mapName;
            this.ownedPartitions = ownedPartitions != null ? ownedPartitions : Collections.emptyList();
            this.fetchSize = fetchSize;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.map = (MapProxyImpl)context.jetInstance().getHazelcastInstance().getMap(this.mapName);
        }

        @Nonnull
        public List<Processor> get(int count) {
            return ReadIMapP.getProcessors(count, this.ownedPartitions, partitionId -> this.map.iterator(this.fetchSize, partitionId.intValue(), true));
        }
    }

    private static class LocalClusterMetaSupplier
    implements ProcessorMetaSupplier {
        static final long serialVersionUID = 1L;
        private final String name;
        private final int fetchSize;
        private transient Map<Address, List<Integer>> addrToPartitions;

        LocalClusterMetaSupplier(String name, int fetchSize) {
            this.name = name;
            this.fetchSize = fetchSize;
        }

        @Override
        public void init(@Nonnull ProcessorMetaSupplier.Context context) {
            this.addrToPartitions = context.jetInstance().getHazelcastInstance().getPartitionService().getPartitions().stream().collect(Collectors.groupingBy(p -> p.getOwner().getAddress(), Collectors.mapping(Partition::getPartitionId, Collectors.toList())));
        }

        @Override
        @Nonnull
        public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresseses) {
            return address -> new LocalClusterProcessorSupplier(this.name, this.addrToPartitions.get(address), this.fetchSize);
        }
    }

    private static class RemoteClusterProcessorSupplier
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final String mapName;
        private final int fetchSize;
        private List<Integer> ownedPartitions;
        private SerializableClientConfig serializableClientConfig;
        private transient HazelcastInstance client;
        private transient ClientMapProxy map;

        RemoteClusterProcessorSupplier(String mapName, int fetchSize, List<Integer> ownedPartitions, SerializableClientConfig serializableClientConfig) {
            this.mapName = mapName;
            this.fetchSize = fetchSize;
            this.ownedPartitions = ownedPartitions;
            this.serializableClientConfig = serializableClientConfig;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.client = HazelcastClient.newHazelcastClient((ClientConfig)this.serializableClientConfig.asClientConfig());
            this.map = (ClientMapProxy)this.client.getMap(this.mapName);
        }

        @Override
        public void complete(Throwable error) {
            this.client.shutdown();
        }

        @Nonnull
        public List<Processor> get(int count) {
            return ReadIMapP.getProcessors(count, this.ownedPartitions, partitionId -> this.map.iterator(this.fetchSize, partitionId.intValue(), true));
        }
    }

    private static class RemoteClusterMetaSupplier
    implements ProcessorMetaSupplier {
        static final long serialVersionUID = 1L;
        private final String name;
        private final int fetchSize;
        private final SerializableClientConfig serializableConfig;
        private transient int remotePartitionCount;

        RemoteClusterMetaSupplier(String name, int fetchSize, ClientConfig clientConfig) {
            this.name = name;
            this.fetchSize = fetchSize;
            this.serializableConfig = new SerializableClientConfig(clientConfig);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init(@Nonnull ProcessorMetaSupplier.Context context) {
            HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)this.serializableConfig.asClientConfig());
            try {
                HazelcastClientProxy clientProxy = (HazelcastClientProxy)client;
                this.remotePartitionCount = clientProxy.client.getClientPartitionService().getPartitionCount();
            }
            finally {
                client.shutdown();
            }
        }

        @Override
        @Nonnull
        public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
            Map<Address, List<Integer>> membersToPartitions = IntStream.range(0, this.remotePartitionCount).boxed().collect(Collectors.groupingBy(partition -> (Address)addresses.get(partition % addresses.size())));
            return address -> new RemoteClusterProcessorSupplier(this.name, this.fetchSize, (List)membersToPartitions.get(address), this.serializableConfig);
        }
    }
}

