/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.jet.impl.deployment.ResourceDescriptor;
import com.hazelcast.jet.impl.deployment.ResourceKind;
import com.hazelcast.util.Preconditions;
import java.io.Serializable;
import java.net.URL;

public class ResourceConfig
implements Serializable {
    private ResourceDescriptor descriptor;
    private URL url;

    public ResourceConfig(URL url, String id, ResourceKind kind) {
        this.descriptor = new ResourceDescriptor(id, kind);
        this.url = url;
    }

    public ResourceConfig(Class clazz) {
        String classAsPath = clazz.getName().replace('.', '/') + ".class";
        this.url = clazz.getClassLoader().getResource(classAsPath);
        Preconditions.checkNotNull((Object)this.url, (String)("Couldn't derive URL from class " + clazz));
        this.descriptor = new ResourceDescriptor(clazz.getName(), ResourceKind.CLASS);
    }

    public URL getUrl() {
        return this.url;
    }

    public ResourceDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return "{resource=" + this.descriptor + ", url=" + this.url + '}';
    }
}

