/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.Distributed;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Processor;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface ProcessorSupplier
extends Serializable {
    default public void init(@Nonnull Context context) {
    }

    @Nonnull
    public Collection<? extends Processor> get(int var1);

    default public void complete(Throwable error) {
    }

    @Nonnull
    public static ProcessorSupplier of(@Nonnull Distributed.Supplier<Processor> processorSupplier) {
        return count -> Stream.generate(processorSupplier).limit(count).collect(Collectors.toList());
    }

    public static interface Context {
        @Nonnull
        public JetInstance jetInstance();

        public int localParallelism();
    }
}

