/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.Distributed;
import com.hazelcast.jet.Edge;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.ProcessorMetaSupplier;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.impl.SerializationConstants;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class DAG
implements IdentifiedDataSerializable,
Iterable<Vertex> {
    private Set<Edge> edges = new LinkedHashSet<Edge>();
    private Map<String, Vertex> verticesByName = new HashMap<String, Vertex>();
    private Set<Vertex> verticesByIdentity = Collections.newSetFromMap(new IdentityHashMap());
    private Deque<Vertex> topologicalVertexStack = new ArrayDeque<Vertex>();

    public Vertex newVertex(String name, Distributed.Supplier<Processor> simpleSupplier) {
        return this.addVertex(new Vertex(name, simpleSupplier));
    }

    public Vertex newVertex(String name, ProcessorSupplier processorSupplier) {
        return this.addVertex(new Vertex(name, processorSupplier));
    }

    public Vertex newVertex(String name, ProcessorMetaSupplier metaSupplier) {
        return this.addVertex(new Vertex(name, metaSupplier));
    }

    public DAG vertex(Vertex vertex) {
        this.addVertex(vertex);
        return this;
    }

    public DAG edge(Edge edge) {
        if (edge.getDestination() == null) {
            throw new IllegalArgumentException("Edge has no destination");
        }
        if (this.edges.contains(edge)) {
            throw new IllegalArgumentException("This DAG already has an edge between '" + edge.getSourceName() + "' and '" + edge.getDestName() + '\'');
        }
        if (!this.containsVertex(edge.getSource())) {
            throw new IllegalArgumentException(this.containsVertexName(edge.getSource()) ? "This DAG has a vertex called '" + edge.getSourceName() + "', but the supplied edge's source is a different vertex with the same name" : "Source vertex '" + edge.getSourceName() + "' is not in this DAG");
        }
        if (!this.containsVertex(edge.getDestination())) {
            throw new IllegalArgumentException(this.containsVertexName(edge.getDestination()) ? "This DAG has a vertex called '" + edge.getDestName() + "', but the supplied edge's destination is a different vertex with the same name" : "Destination vertex '" + edge.getDestName() + "' is not in this DAG");
        }
        if (this.getInboundEdges(edge.getDestName()).stream().anyMatch(e -> e.getDestOrdinal() == edge.getDestOrdinal())) {
            throw new IllegalArgumentException("Vertex '" + edge.getDestName() + "' already has an inbound edge at ordinal " + edge.getDestOrdinal() + (edge.getSourceOrdinal() == 0 && edge.getDestOrdinal() == 0 ? ", use Edge.from().to() to specify another ordinal" : ""));
        }
        if (this.getOutboundEdges(edge.getSourceName()).stream().anyMatch(e -> e.getSourceOrdinal() == edge.getSourceOrdinal())) {
            throw new IllegalArgumentException("Vertex '" + edge.getSourceName() + "' already has an outbound edge at ordinal " + edge.getSourceOrdinal() + (edge.getSourceOrdinal() == 0 && edge.getDestOrdinal() == 0 ? ", use Edge.from().to() to specify another ordinal" : ""));
        }
        this.edges.add(edge);
        return this;
    }

    public List<Edge> getInboundEdges(String vertexName) {
        if (!this.verticesByName.containsKey(vertexName)) {
            throw new IllegalArgumentException("No vertex with name '" + vertexName + "' found in this DAG");
        }
        ArrayList<Edge> inboundEdges = new ArrayList<Edge>();
        for (Edge edge : this.edges) {
            if (!edge.getDestName().equals(vertexName)) continue;
            inboundEdges.add(edge);
        }
        return inboundEdges;
    }

    public List<Edge> getOutboundEdges(String vertexName) {
        if (!this.verticesByName.containsKey(vertexName)) {
            throw new IllegalArgumentException("No vertex with name '" + vertexName + "' found in this DAG");
        }
        ArrayList<Edge> outboundEdges = new ArrayList<Edge>();
        for (Edge edge : this.edges) {
            if (!edge.getSourceName().equals(vertexName)) continue;
            outboundEdges.add(edge);
        }
        return outboundEdges;
    }

    public Vertex getVertex(String vertexName) {
        return this.verticesByName.get(vertexName);
    }

    public Iterator<Vertex> reverseIterator() {
        this.validate();
        return Collections.unmodifiableCollection(this.topologicalVertexStack).iterator();
    }

    @Override
    public Iterator<Vertex> iterator() {
        this.validate();
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(this.topologicalVertexStack);
        Collections.reverse(vertices);
        return Collections.unmodifiableCollection(vertices).iterator();
    }

    public String toString() {
        StringBuilder b = new StringBuilder("dag\n");
        for (Vertex v : this) {
            b.append("    .vertex(\"").append(v.getName()).append("\")");
            if (v.getLocalParallelism() != -1) {
                b.append(".localParallelism(").append(v.getLocalParallelism()).append(')');
            }
            b.append('\n');
        }
        for (Edge e : this.edges) {
            b.append("    .edge(").append(e).append(")\n");
        }
        return b.toString();
    }

    void validate() throws IllegalArgumentException {
        this.topologicalVertexStack.clear();
        Preconditions.checkTrue((!this.verticesByName.isEmpty() ? 1 : 0) != 0, (String)"DAG must contain at least one vertex");
        Map<String, List<Edge>> outgoingEdgeMap = this.edges.stream().collect(Collectors.groupingBy(Edge::getSourceName));
        DAG.validateAgainstMultigraph(this.edges);
        DAG.validateOutboundEdgeOrdinals(outgoingEdgeMap);
        DAG.validateInboundEdgeOrdinals(this.edges.stream().collect(Collectors.groupingBy(Edge::getDestName)));
        this.detectCycles(outgoingEdgeMap, this.verticesByName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> new AnnotatedVertex((Vertex)v.getValue()))));
    }

    private Vertex addVertex(Vertex vertex) {
        if (this.verticesByName.containsKey(vertex.getName())) {
            throw new IllegalArgumentException("Vertex " + vertex.getName() + " is already defined.");
        }
        this.verticesByIdentity.add(vertex);
        this.verticesByName.put(vertex.getName(), vertex);
        return vertex;
    }

    private boolean containsVertex(Vertex vertex) {
        return this.verticesByIdentity.contains(vertex);
    }

    private boolean containsVertexName(Vertex vertex) {
        return this.verticesByName.containsKey(vertex.getName());
    }

    private static void validateOutboundEdgeOrdinals(Map<String, List<Edge>> outgoingEdgeMap) {
        for (Map.Entry<String, List<Edge>> entry : outgoingEdgeMap.entrySet()) {
            String vertex = entry.getKey();
            int[] ordinals = entry.getValue().stream().mapToInt(Edge::getSourceOrdinal).sorted().toArray();
            for (int i = 0; i < ordinals.length; ++i) {
                if (ordinals[i] == i) continue;
                throw new IllegalArgumentException("Output ordinals for vertex " + vertex + " are not ordered. " + "Actual: " + Arrays.toString(ordinals) + " Expected: " + Arrays.toString(IntStream.range(0, ordinals.length).toArray()));
            }
        }
    }

    private void detectCycles(Map<String, List<Edge>> edgeMap, Map<String, AnnotatedVertex> vertexMap) throws IllegalArgumentException {
        Integer nextIndex = 0;
        ArrayDeque<AnnotatedVertex> stack = new ArrayDeque<AnnotatedVertex>();
        for (AnnotatedVertex av : vertexMap.values()) {
            if (av.index != -1) continue;
            assert (stack.isEmpty());
            this.strongConnect(av, vertexMap, edgeMap, stack, nextIndex);
        }
    }

    private void strongConnect(AnnotatedVertex av, Map<String, AnnotatedVertex> vertexMap, Map<String, List<Edge>> edgeMap, Deque<AnnotatedVertex> stack, Integer nextIndex) throws IllegalArgumentException {
        av.index = nextIndex;
        av.lowlink = nextIndex;
        Integer n = nextIndex;
        nextIndex = nextIndex + 1;
        Integer n2 = nextIndex;
        stack.addLast(av);
        av.onstack = true;
        List<Edge> edges = edgeMap.get(av.v.getName());
        if (edges != null) {
            for (Edge e : edgeMap.get(av.v.getName())) {
                AnnotatedVertex outVertex = vertexMap.get(e.getDestName());
                if (outVertex.index == -1) {
                    this.strongConnect(outVertex, vertexMap, edgeMap, stack, nextIndex);
                    av.lowlink = Math.min(av.lowlink, outVertex.lowlink);
                    continue;
                }
                if (!outVertex.onstack) continue;
                av.lowlink = Math.min(av.lowlink, outVertex.index);
            }
        }
        if (av.lowlink == av.index) {
            AnnotatedVertex pop = stack.removeLast();
            pop.onstack = false;
            if (pop != av) {
                StringBuilder message = new StringBuilder();
                message.append(av.v.getName()).append(" <- ");
                while (pop != av) {
                    message.append(pop.v.getName()).append(" <- ");
                    pop.onstack = false;
                    pop = stack.removeLast();
                }
                message.append(av.v.getName());
                throw new IllegalArgumentException("DAG contains a cycle: " + message);
            }
            if (edgeMap.containsKey(pop.v.getName())) {
                for (Edge edge : edgeMap.get(pop.v.getName())) {
                    if (!edge.getDestName().equals(pop.v.getName())) continue;
                    throw new IllegalArgumentException("DAG contains a self-cycle on vertex:" + pop.v.getName());
                }
            }
            this.topologicalVertexStack.addLast(av.v);
        }
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.verticesByName.size());
        for (Map.Entry<String, Vertex> entry : this.verticesByName.entrySet()) {
            out.writeObject((Object)entry.getKey());
            out.writeObject((Object)entry.getValue());
        }
        out.writeInt(this.edges.size());
        for (Edge edge : this.edges) {
            out.writeObject((Object)edge);
        }
    }

    public void readData(ObjectDataInput in) throws IOException {
        int vertexCount = in.readInt();
        for (int i = 0; i < vertexCount; ++i) {
            String key = (String)in.readObject();
            Vertex value = (Vertex)in.readObject();
            this.verticesByName.put(key, value);
        }
        int edgeCount = in.readInt();
        for (int i = 0; i < edgeCount; ++i) {
            Edge edge = (Edge)in.readObject();
            this.edges.add(edge);
        }
    }

    public int getFactoryId() {
        return SerializationConstants.FACTORY_ID;
    }

    public int getId() {
        return 0;
    }

    private static void validateAgainstMultigraph(Collection<Edge> edges) {
        HashSet<Map.Entry<String, String>> distinctSrcDest = new HashSet<Map.Entry<String, String>>();
        for (Edge e : edges) {
            Map.Entry<String, String> srcDestId = Util.entry(e.getSourceName(), e.getDestName());
            if (distinctSrcDest.add(srcDestId)) continue;
            throw new IllegalArgumentException(String.format("Duplicate edge: %s -> %s", srcDestId.getKey(), srcDestId.getValue()));
        }
    }

    private static void validateInboundEdgeOrdinals(Map<String, List<Edge>> incomingEdgeMap) {
        for (Map.Entry<String, List<Edge>> entry : incomingEdgeMap.entrySet()) {
            String vertex = entry.getKey();
            int[] ordinals = entry.getValue().stream().mapToInt(Edge::getDestOrdinal).sorted().toArray();
            for (int i = 0; i < ordinals.length; ++i) {
                if (ordinals[i] == i) continue;
                throw new IllegalArgumentException("Input ordinals for vertex " + vertex + " are not ordered. " + "Actual: " + Arrays.toString(ordinals) + " Expected: " + Arrays.toString(IntStream.range(0, ordinals.length).toArray()));
            }
        }
    }

    private static final class AnnotatedVertex {
        Vertex v;
        int index;
        int lowlink;
        boolean onstack;

        private AnnotatedVertex(Vertex v) {
            this.v = v;
            this.index = -1;
            this.lowlink = -1;
        }
    }
}

