/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.FullScanPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexNode;

public class JoinNestedLoopPhysicalRel
extends Join
implements PhysicalRel {
    JoinNestedLoopPhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) {
        super(cluster, traitSet, Collections.emptyList(), left, right, condition, Collections.emptySet(), joinType);
    }

    public Expression<Boolean> rightFilter() {
        return ((FullScanPhysicalRel)this.getRight()).filter();
    }

    public List<Expression<?>> rightProjection() {
        return ((FullScanPhysicalRel)this.getRight()).projection();
    }

    public JetJoinInfo joinInfo() {
        int[] leftKeys = this.analyzeCondition().leftKeys.toIntArray();
        HazelcastTable table = (HazelcastTable)this.getRight().getTable().unwrap(HazelcastTable.class);
        List projects = table.getProjects();
        int[] rightKeys = Arrays.stream(this.analyzeCondition().rightKeys.toIntArray()).map(projects::get).toArray();
        Expression nonEquiCondition = this.filter((PlanNodeFieldTypeProvider)this.schema(), this.analyzeCondition().getRemaining(this.getCluster().getRexBuilder()));
        Expression condition = this.filter((PlanNodeFieldTypeProvider)this.schema(), this.getCondition());
        return new JetJoinInfo(this.getJoinType(), leftKeys, rightKeys, (Expression<Boolean>)nonEquiCondition, (Expression<Boolean>)condition);
    }

    @Override
    public PlanNodeSchema schema() {
        PlanNodeSchema leftSchema = ((PhysicalRel)this.getLeft()).schema();
        PlanNodeSchema rightSchema = ((PhysicalRel)this.getRight()).schema();
        return PlanNodeSchema.combine((PlanNodeSchema)leftSchema, (PlanNodeSchema)rightSchema);
    }

    @Override
    public Vertex accept(CreateDagVisitor visitor) {
        return visitor.onNestedLoopJoin(this);
    }

    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new JoinNestedLoopPhysicalRel(this.getCluster(), traitSet, left, right, this.getCondition(), joinType);
    }
}

