/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.infoschema;

import com.hazelcast.jet.sql.impl.connector.infoschema.InfoSchemaTable;
import com.hazelcast.jet.sql.impl.schema.Mapping;
import com.hazelcast.jet.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MappingColumnsTable
extends InfoSchemaTable {
    private static final String NAME = "columns";
    private static final List<TableField> FIELDS = Arrays.asList(new TableField("table_catalog", QueryDataType.VARCHAR, false), new TableField("table_schema", QueryDataType.VARCHAR, false), new TableField("table_name", QueryDataType.VARCHAR, false), new TableField("column_name", QueryDataType.VARCHAR, false), new TableField("column_external_name", QueryDataType.VARCHAR, false), new TableField("ordinal_position", QueryDataType.INT, false), new TableField("is_nullable", QueryDataType.VARCHAR, false), new TableField("data_type", QueryDataType.VARCHAR, false));
    private final String mappingsSchema;
    private final Collection<Mapping> mappings;

    public MappingColumnsTable(String catalog, String schemaName, String mappingsSchema, Collection<Mapping> mappings) {
        super(FIELDS, catalog, schemaName, NAME, (TableStatistics)new ConstantTableStatistics((long)mappings.size() * (long)FIELDS.size()));
        this.mappingsSchema = mappingsSchema;
        this.mappings = mappings;
    }

    @Override
    protected List<Object[]> rows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this.mappings.size());
        for (Mapping mapping : this.mappings) {
            List<MappingField> fields = mapping.fields();
            for (int i = 0; i < fields.size(); ++i) {
                MappingField field = fields.get(i);
                Object[] row = new Object[]{this.catalog(), this.mappingsSchema, mapping.name(), field.name(), field.externalName(), i + 1, String.valueOf(true), field.type().getTypeFamily().name()};
                rows.add(row);
            }
        }
        return rows;
    }
}

