/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.jet.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class JsonResolver {
    private JsonResolver() {
    }

    static List<MappingField> resolveFields(Map<String, Object> json) {
        LinkedHashMap<String, MappingField> fields = new LinkedHashMap<String, MappingField>();
        for (Map.Entry<String, Object> entry : json.entrySet()) {
            String name = entry.getKey();
            QueryDataType type = JsonResolver.resolveType(entry.getValue());
            MappingField field = new MappingField(name, type);
            fields.putIfAbsent(field.name(), field);
        }
        return new ArrayList<MappingField>(fields.values());
    }

    private static QueryDataType resolveType(Object value) {
        if (value instanceof Boolean) {
            return QueryDataType.BOOLEAN;
        }
        if (value instanceof Number) {
            return QueryDataType.DOUBLE;
        }
        if (value instanceof String) {
            return QueryDataType.VARCHAR;
        }
        return QueryDataType.OBJECT;
    }
}

