/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate.function;

import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.calcite.validate.operators.common.HazelcastAggFunction;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Optionality;

public class HazelcastSumAggFunction
extends HazelcastAggFunction {
    public HazelcastSumAggFunction() {
        super("SUM", SqlKind.SUM, ReturnTypes.AGG_SUM, (SqlOperandTypeInference)new ReplaceUnknownOperandTypeInference(SqlTypeName.BIGINT), null, SqlFunctionCategory.NUMERIC, false, false, Optionality.FORBIDDEN);
    }

    protected boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        SqlTypeName resultTypeName;
        RelDataType operandType = binding.getOperandType(0);
        if (!HazelcastTypeUtils.isNumericType((RelDataType)operandType)) {
            if (throwOnFailure) {
                throw binding.newValidationSignatureError();
            }
            return false;
        }
        switch (operandType.getSqlTypeName()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: {
                resultTypeName = SqlTypeName.BIGINT;
                break;
            }
            case BIGINT: 
            case DECIMAL: {
                resultTypeName = SqlTypeName.DECIMAL;
                break;
            }
            case REAL: {
                resultTypeName = SqlTypeName.REAL;
                break;
            }
            case DOUBLE: {
                resultTypeName = SqlTypeName.DOUBLE;
                break;
            }
            default: {
                throw new UnsupportedOperationException(operandType.getSqlTypeName().toString());
            }
        }
        RelDataType resultType = HazelcastTypeFactory.INSTANCE.createSqlType(resultTypeName);
        TypedOperandChecker checker = TypedOperandChecker.forType((RelDataType)resultType);
        assert (checker.isNumeric());
        return checker.check(binding, throwOnFailure, 0);
    }
}

