/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.AbstractSqlResult;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryResultProducer;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.ResultIterator;
import com.hazelcast.sql.impl.SqlRowImpl;
import com.hazelcast.sql.impl.row.Row;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class JetSqlResultImpl
extends AbstractSqlResult {
    private final QueryId queryId;
    private final QueryResultProducer rootResultConsumer;
    private final SqlRowMetadata rowMetadata;
    private final boolean isInfiniteRows;
    private ResultIterator<SqlRow> iterator;

    JetSqlResultImpl(QueryId queryId, QueryResultProducer rootResultConsumer, SqlRowMetadata rowMetadata, boolean isInfiniteRows) {
        this.queryId = queryId;
        this.rootResultConsumer = rootResultConsumer;
        this.rowMetadata = rowMetadata;
        this.isInfiniteRows = isInfiniteRows;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public boolean isInfiniteRows() {
        return this.isInfiniteRows;
    }

    @Nonnull
    public SqlRowMetadata getRowMetadata() {
        return this.rowMetadata;
    }

    @Nonnull
    public ResultIterator<SqlRow> iterator() {
        if (this.iterator == null) {
            this.iterator = new RowToSqlRowIterator(this.rootResultConsumer.iterator());
            return this.iterator;
        }
        throw new IllegalStateException("Iterator can be requested only once.");
    }

    public long updateCount() {
        return -1L;
    }

    public void close(@Nullable QueryException exception) {
        if (exception == null) {
            exception = QueryException.cancelledByUser();
        }
        this.rootResultConsumer.onError(exception);
    }

    private final class RowToSqlRowIterator
    implements ResultIterator<SqlRow> {
        private final ResultIterator<Row> delegate;

        private RowToSqlRowIterator(ResultIterator<Row> delegate) {
            this.delegate = delegate;
        }

        public boolean hasNext() {
            try {
                return this.delegate.hasNext();
            }
            catch (Exception e) {
                throw QueryUtils.toPublicException((Throwable)e, (UUID)JetSqlResultImpl.this.queryId.getMemberId());
            }
        }

        public ResultIterator.HasNextResult hasNext(long timeout, TimeUnit timeUnit) {
            try {
                return this.delegate.hasNext(timeout, timeUnit);
            }
            catch (Exception e) {
                throw QueryUtils.toPublicException((Throwable)e, (UUID)JetSqlResultImpl.this.queryId.getMemberId());
            }
        }

        public SqlRow next() {
            try {
                return new SqlRowImpl(JetSqlResultImpl.this.getRowMetadata(), (Row)this.delegate.next());
            }
            catch (NoSuchElementException e) {
                throw e;
            }
            catch (Exception e) {
                throw QueryUtils.toPublicException((Throwable)e, (UUID)JetSqlResultImpl.this.queryId.getMemberId());
            }
        }
    }
}

