/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.parse.SqlDataType;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlMappingColumn
extends SqlCall {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("COLUMN DECLARATION", SqlKind.COLUMN_DECL);
    private final SqlIdentifier name;
    private final SqlDataType type;
    private final SqlIdentifier externalName;

    public SqlMappingColumn(SqlIdentifier name, SqlDataType type, SqlIdentifier externalName, SqlParserPos pos) {
        super(pos);
        this.name = Objects.requireNonNull(name, "Column name should not be null");
        this.type = Objects.requireNonNull(type, "Column type should not be null");
        this.externalName = externalName;
    }

    public String name() {
        return this.name.getSimple();
    }

    public QueryDataType type() {
        return this.type != null ? this.type.type() : null;
    }

    public String externalName() {
        return this.externalName == null ? null : this.externalName.toString();
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)((Object)this.type), (Object)this.externalName);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.type != null) {
            this.type.unparse(writer, leftPrec, rightPrec);
        }
        if (this.externalName != null) {
            writer.keyword("EXTERNAL NAME");
            this.externalName.unparse(writer, leftPrec, rightPrec);
        }
    }
}

