/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.schema.JetDynamicTableFunction;
import com.hazelcast.jet.sql.impl.schema.JetSpecificTableFunction;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.row.EmptyRow;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;

final class FullFunctionScanLogicalRules {
    static final RelOptRule SPECIFIC_FUNCTION_INSTANCE = new ConverterRule(LogicalTableFunctionScan.class, scan -> FullFunctionScanLogicalRules.extractSpecificFunction(scan) != null, (RelTrait)Convention.NONE, (RelTrait)Convention.NONE, FullFunctionScanLogicalRules.class.getSimpleName() + "(Specific)"){

        public RelNode convert(RelNode rel) {
            LogicalTableFunctionScan scan = (LogicalTableFunctionScan)rel;
            return OptUtils.createLogicalScan(scan.getCluster(), this.extractTable(scan));
        }

        private HazelcastTable extractTable(LogicalTableFunctionScan scan) {
            JetSpecificTableFunction specificFunction = FullFunctionScanLogicalRules.extractSpecificFunction(scan);
            List operands = ((RexCall)scan.getCall()).getOperands();
            RexVisitor<Expression<?>> visitor = OptUtils.createRexToExpressionVisitor(FailingFieldTypeProvider.INSTANCE);
            List<Object> arguments = IntStream.range(0, specificFunction.getOperandCountRange().getMax()).mapToObj(index -> {
                if (index < operands.size()) {
                    Expression expression = (Expression)((RexNode)operands.get(index)).accept(visitor);
                    return expression.eval((Row)EmptyRow.INSTANCE, ExpressionUtil.NOT_IMPLEMENTED_ARGUMENTS_CONTEXT);
                }
                return null;
            }).collect(Collectors.toList());
            return specificFunction.toTable(arguments);
        }
    };
    static final RelOptRule DYNAMIC_FUNCTION_INSTANCE = new ConverterRule(LogicalTableFunctionScan.class, scan -> FullFunctionScanLogicalRules.extractDynamicFunction(scan) != null, (RelTrait)Convention.NONE, (RelTrait)Convention.NONE, FullFunctionScanLogicalRules.class.getSimpleName() + "(Dynamic)"){

        public RelNode convert(RelNode rel) {
            LogicalTableFunctionScan scan = (LogicalTableFunctionScan)rel;
            return OptUtils.createLogicalScan(scan.getCluster(), this.extractTable(scan));
        }

        private HazelcastTable extractTable(LogicalTableFunctionScan scan) {
            JetDynamicTableFunction dynamicFunction = FullFunctionScanLogicalRules.extractDynamicFunction(scan);
            return dynamicFunction.toTable(scan.getRowType());
        }
    };

    private FullFunctionScanLogicalRules() {
    }

    private static JetSpecificTableFunction extractSpecificFunction(LogicalTableFunctionScan scan) {
        if (scan == null || !(scan.getCall() instanceof RexCall)) {
            return null;
        }
        RexCall call = (RexCall)scan.getCall();
        if (!(call.getOperator() instanceof JetSpecificTableFunction)) {
            return null;
        }
        return (JetSpecificTableFunction)call.getOperator();
    }

    private static JetDynamicTableFunction extractDynamicFunction(LogicalTableFunctionScan scan) {
        if (scan == null || !(scan.getCall() instanceof RexCall)) {
            return null;
        }
        RexCall call = (RexCall)scan.getCall();
        if (!(call.getOperator() instanceof SqlUserDefinedTableFunction)) {
            return null;
        }
        SqlUserDefinedTableFunction operator = (SqlUserDefinedTableFunction)call.getOperator();
        if (!(operator.getFunction() instanceof JetDynamicTableFunction)) {
            return null;
        }
        return (JetDynamicTableFunction)operator.getFunction();
    }

    private static final class FailingFieldTypeProvider
    implements PlanNodeFieldTypeProvider {
        private static final FailingFieldTypeProvider INSTANCE = new FailingFieldTypeProvider();

        private FailingFieldTypeProvider() {
        }

        public QueryDataType getType(int index) {
            throw new IllegalStateException("The operation should not be called.");
        }
    }
}

