/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataType;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;

@NotThreadSafe
class AvroUpsertTarget
implements UpsertTarget {
    private final Schema schema;
    private GenericRecordBuilder record;

    AvroUpsertTarget(String schema) {
        this.schema = new Schema.Parser().parse(schema);
    }

    @Override
    public UpsertInjector createInjector(@Nullable String path, QueryDataType type) {
        if (path == null) {
            return UpsertInjector.FAILING_TOP_LEVEL_INJECTOR;
        }
        switch (type.getTypeFamily()) {
            case TINYINT: {
                return value -> this.record.set(path, value == null ? null : Integer.valueOf(((Byte)value).intValue()));
            }
            case SMALLINT: {
                return value -> this.record.set(path, value == null ? null : Integer.valueOf(((Short)value).intValue()));
            }
            case BOOLEAN: 
            case INTEGER: 
            case BIGINT: 
            case REAL: 
            case DOUBLE: {
                return value -> this.record.set(path, value);
            }
            case DECIMAL: 
            case TIME: 
            case DATE: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_TIME_ZONE: 
            case VARCHAR: {
                return value -> this.record.set(path, QueryDataType.VARCHAR.convert(value));
            }
            case OBJECT: {
                return this.createObjectInjector(path);
            }
        }
        throw QueryException.error((String)("Unsupported type: " + type));
    }

    private UpsertInjector createObjectInjector(String path) {
        return value -> {
            if (value == null) {
                this.record.set(path, null);
            } else {
                if (value instanceof GenericContainer) {
                    throw QueryException.error((String)("Cannot set value of type " + value.getClass().getName() + " to field \"" + path + "\""));
                }
                if (value instanceof Byte) {
                    this.record.set(path, (Object)((Byte)value).intValue());
                } else if (value instanceof Short) {
                    this.record.set(path, (Object)((Short)value).intValue());
                } else if (value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
                    this.record.set(path, value);
                } else {
                    this.record.set(path, QueryDataType.VARCHAR.convert(value));
                }
            }
        };
    }

    @Override
    public void init() {
        this.record = new GenericRecordBuilder(this.schema);
    }

    @Override
    public Object conclude() {
        GenericData.Record record = this.record.build();
        this.record = null;
        return record;
    }
}

