/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.sql.impl.JetPlan;
import com.hazelcast.jet.sql.impl.JetPlanExecutor;
import com.hazelcast.jet.sql.impl.JetQueryResultProducer;
import com.hazelcast.jet.sql.impl.JetSqlBackend;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.map.JetMapMetadataResolverImpl;
import com.hazelcast.jet.sql.impl.schema.MappingCatalog;
import com.hazelcast.jet.sql.impl.schema.MappingStorage;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.impl.JetSqlCoreBackend;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.schema.map.JetMapMetadataResolver;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class JetSqlCoreBackendImpl
implements JetSqlCoreBackend,
ManagedService {
    private MappingCatalog catalog;
    private JetSqlBackend sqlBackend;
    private Map<Long, JetQueryResultProducer> resultConsumerRegistry;

    public void init(@Nonnull AbstractJetInstance jetInstance) {
        HazelcastInstanceImpl hazelcastInstance = (HazelcastInstanceImpl)jetInstance.getHazelcastInstance();
        NodeEngineImpl nodeEngine = hazelcastInstance.node.nodeEngine;
        MappingStorage mappingStorage = new MappingStorage((NodeEngine)nodeEngine);
        SqlConnectorCache connectorCache = new SqlConnectorCache((NodeEngine)nodeEngine);
        MappingCatalog mappingCatalog = new MappingCatalog((NodeEngine)nodeEngine, mappingStorage, connectorCache);
        this.resultConsumerRegistry = new ConcurrentHashMap<Long, JetQueryResultProducer>();
        JetPlanExecutor planExecutor = new JetPlanExecutor(mappingCatalog, jetInstance, this.resultConsumerRegistry);
        this.catalog = mappingCatalog;
        this.sqlBackend = new JetSqlBackend((NodeEngine)nodeEngine, planExecutor);
    }

    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    public List<TableResolver> tableResolvers() {
        return Collections.singletonList(this.catalog);
    }

    public JetMapMetadataResolver mapMetadataResolver() {
        return JetMapMetadataResolverImpl.INSTANCE;
    }

    public Object sqlBackend() {
        return this.sqlBackend;
    }

    public SqlResult execute(QueryId queryId, SqlPlan plan, List<Object> params, long timeout, int pageSize) {
        assert (params == null || params.isEmpty());
        if (timeout > 0L) {
            throw new JetException("Query timeout not yet supported");
        }
        return ((JetPlan)plan).execute(queryId);
    }

    public Map<Long, JetQueryResultProducer> getResultConsumerRegistry() {
        return this.resultConsumerRegistry;
    }

    public void reset() {
    }

    public void shutdown(boolean terminate) {
    }
}

