/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.sql.impl.JetPlan;
import com.hazelcast.jet.sql.impl.JetPlanExecutor;
import com.hazelcast.jet.sql.impl.JetSqlToRelConverter;
import com.hazelcast.jet.sql.impl.calcite.parser.JetSqlParser;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalRules;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.JetRootRel;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRules;
import com.hazelcast.jet.sql.impl.parse.SqlAlterJob;
import com.hazelcast.jet.sql.impl.parse.SqlCreateJob;
import com.hazelcast.jet.sql.impl.parse.SqlCreateMapping;
import com.hazelcast.jet.sql.impl.parse.SqlCreateSnapshot;
import com.hazelcast.jet.sql.impl.parse.SqlDropJob;
import com.hazelcast.jet.sql.impl.parse.SqlDropMapping;
import com.hazelcast.jet.sql.impl.parse.SqlDropSnapshot;
import com.hazelcast.jet.sql.impl.parse.SqlExtendedInsert;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement;
import com.hazelcast.jet.sql.impl.schema.Mapping;
import com.hazelcast.jet.sql.impl.schema.MappingField;
import com.hazelcast.jet.sql.impl.validate.JetSqlValidator;
import com.hazelcast.jet.sql.impl.validate.UnsupportedOperationVisitor;
import com.hazelcast.logging.ILogger;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.calcite.OptimizerContext;
import com.hazelcast.sql.impl.calcite.SqlBackend;
import com.hazelcast.sql.impl.calcite.parse.QueryConvertResult;
import com.hazelcast.sql.impl.calcite.parse.QueryParseResult;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.optimizer.OptimizationTask;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import com.hazelcast.sql.impl.schema.map.AbstractMapTable;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;

class JetSqlBackend
implements SqlBackend {
    private final NodeEngine nodeEngine;
    private final JetPlanExecutor planExecutor;
    private final ILogger logger;

    JetSqlBackend(NodeEngine nodeEngine, JetPlanExecutor planExecutor) {
        this.nodeEngine = nodeEngine;
        this.planExecutor = planExecutor;
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    public SqlParserImplFactory parserFactory() {
        return JetSqlParser.FACTORY;
    }

    public SqlValidator validator(Prepare.CatalogReader catalogReader, HazelcastTypeFactory typeFactory, SqlConformance sqlConformance) {
        return new JetSqlValidator((SqlValidatorCatalogReader)catalogReader, typeFactory, sqlConformance);
    }

    public SqlVisitor<Void> unsupportedOperationVisitor(Prepare.CatalogReader catalogReader) {
        return UnsupportedOperationVisitor.INSTANCE;
    }

    public SqlToRelConverter converter(RelOptTable.ViewExpander viewExpander, SqlValidator sqlValidator, Prepare.CatalogReader catalogReader, RelOptCluster relOptCluster, SqlRexConvertletTable sqlRexConvertletTable, SqlToRelConverter.Config config) {
        return new JetSqlToRelConverter(viewExpander, sqlValidator, catalogReader, relOptCluster, sqlRexConvertletTable, config);
    }

    public SqlPlan createPlan(OptimizationTask task, QueryParseResult parseResult, OptimizerContext context) {
        SqlNode node = parseResult.getNode();
        if (parseResult.getParameterMetadata() != null && parseResult.getParameterMetadata().getParameterCount() != 0) {
            throw QueryException.error((String)"Query parameters not yet supported");
        }
        if (node instanceof SqlCreateMapping) {
            return this.toCreateMappingPlan((SqlCreateMapping)node);
        }
        if (node instanceof SqlDropMapping) {
            return this.toDropMappingPlan((SqlDropMapping)node);
        }
        if (node instanceof SqlCreateJob) {
            return this.toCreateJobPlan(parseResult, context);
        }
        if (node instanceof SqlAlterJob) {
            return this.toAlterJobPlan((SqlAlterJob)node);
        }
        if (node instanceof SqlDropJob) {
            return this.toDropJobPlan((SqlDropJob)node);
        }
        if (node instanceof SqlCreateSnapshot) {
            return this.toCreateSnapshotPlan((SqlCreateSnapshot)node);
        }
        if (node instanceof SqlDropSnapshot) {
            return this.toDropSnapshotPlan((SqlDropSnapshot)node);
        }
        if (node instanceof SqlShowStatement) {
            return this.toShowStatementPlan((SqlShowStatement)node);
        }
        QueryConvertResult convertResult = context.convert(parseResult);
        return this.toPlan(convertResult.getRel(), convertResult.getFieldNames(), context, parseResult.isInfiniteRows());
    }

    private SqlPlan toCreateMappingPlan(SqlCreateMapping sqlCreateMapping) {
        List<MappingField> mappingFields = sqlCreateMapping.columns().map(field -> new MappingField(field.name(), field.type(), field.externalName())).collect(Collectors.toList());
        Mapping mapping = new Mapping(sqlCreateMapping.nameWithoutSchema(), sqlCreateMapping.externalName(), sqlCreateMapping.type(), mappingFields, sqlCreateMapping.options());
        return new JetPlan.CreateMappingPlan(mapping, sqlCreateMapping.getReplace(), sqlCreateMapping.ifNotExists(), this.planExecutor);
    }

    private SqlPlan toDropMappingPlan(SqlDropMapping sqlDropMapping) {
        return new JetPlan.DropMappingPlan(sqlDropMapping.nameWithoutSchema(), sqlDropMapping.ifExists(), this.planExecutor);
    }

    private SqlPlan toCreateJobPlan(QueryParseResult parseResult, OptimizerContext context) {
        SqlCreateJob sqlCreateJob = (SqlCreateJob)parseResult.getNode();
        SqlExtendedInsert source = sqlCreateJob.dmlStatement();
        QueryParseResult dmlParseResult = new QueryParseResult((SqlNode)source, parseResult.getParameterMetadata(), parseResult.getValidator(), (SqlBackend)this, false);
        QueryConvertResult dmlConvertedResult = context.convert(dmlParseResult);
        JetPlan.SelectOrSinkPlan dmlPlan = this.toPlan(dmlConvertedResult.getRel(), dmlConvertedResult.getFieldNames(), context, dmlParseResult.isInfiniteRows());
        assert (dmlPlan.isInsert());
        return new JetPlan.CreateJobPlan(sqlCreateJob.name(), sqlCreateJob.jobConfig(), sqlCreateJob.ifNotExists(), dmlPlan, this.planExecutor);
    }

    private SqlPlan toAlterJobPlan(SqlAlterJob sqlAlterJob) {
        return new JetPlan.AlterJobPlan(sqlAlterJob.name(), sqlAlterJob.getOperation(), this.planExecutor);
    }

    private SqlPlan toDropJobPlan(SqlDropJob sqlDropJob) {
        return new JetPlan.DropJobPlan(sqlDropJob.name(), sqlDropJob.ifExists(), sqlDropJob.withSnapshotName(), this.planExecutor);
    }

    private SqlPlan toCreateSnapshotPlan(SqlCreateSnapshot sqlNode) {
        return new JetPlan.CreateSnapshotPlan(sqlNode.getSnapshotName(), sqlNode.getJobName(), this.planExecutor);
    }

    private SqlPlan toDropSnapshotPlan(SqlDropSnapshot sqlNode) {
        return new JetPlan.DropSnapshotPlan(sqlNode.getSnapshotName(), sqlNode.isIfExists(), this.planExecutor);
    }

    private SqlPlan toShowStatementPlan(SqlShowStatement sqlNode) {
        return new JetPlan.ShowStatementPlan(sqlNode.getTarget(), this.planExecutor);
    }

    private JetPlan.SelectOrSinkPlan toPlan(RelNode rel, List<String> fieldNames, OptimizerContext context, boolean isInfiniteRows) {
        this.logger.fine("Before logical opt:\n" + RelOptUtil.toString((RelNode)rel));
        LogicalRel logicalRel = this.optimizeLogical(context, rel);
        this.logger.fine("After logical opt:\n" + RelOptUtil.toString((RelNode)logicalRel));
        PhysicalRel physicalRel = this.optimizePhysical(context, logicalRel);
        this.logger.fine("After physical opt:\n" + RelOptUtil.toString((RelNode)physicalRel));
        boolean isInsert = physicalRel instanceof TableModify;
        List<Permission> permissions = this.extractPermissions(physicalRel);
        if (isInsert) {
            DAG dag = this.createDag(physicalRel);
            return new JetPlan.SelectOrSinkPlan(dag, isInfiniteRows, true, null, this.planExecutor, permissions);
        }
        DAG dag = this.createDag(new JetRootRel(physicalRel, this.nodeEngine.getThisAddress()));
        SqlRowMetadata rowMetadata = this.createRowMetadata(fieldNames, physicalRel.schema().getTypes());
        return new JetPlan.SelectOrSinkPlan(dag, isInfiniteRows, false, rowMetadata, this.planExecutor, permissions);
    }

    private List<Permission> extractPermissions(PhysicalRel physicalRel) {
        final ArrayList<Permission> permissions = new ArrayList<Permission>();
        physicalRel.accept((RelShuttle)new RelShuttleImpl(){

            public RelNode visit(TableScan scan) {
                this.addPermissionForTable(scan.getTable(), "read");
                return super.visit(scan);
            }

            public RelNode visit(RelNode other) {
                this.addPermissionForTable(other.getTable(), "put");
                return super.visit(other);
            }

            private void addPermissionForTable(RelOptTable t, String action) {
                if (t == null) {
                    return;
                }
                HazelcastTable table = (HazelcastTable)t.unwrap(HazelcastTable.class);
                if (table != null && table.getTarget() instanceof AbstractMapTable) {
                    String mapName = ((AbstractMapTable)table.getTarget()).getMapName();
                    permissions.add(new MapPermission(mapName, new String[]{action}));
                }
            }
        });
        return permissions;
    }

    private LogicalRel optimizeLogical(OptimizerContext context, RelNode rel) {
        return (LogicalRel)context.optimize(rel, LogicalRules.getRuleSet(), OptUtils.toLogicalConvention(rel.getTraitSet()));
    }

    private PhysicalRel optimizePhysical(OptimizerContext context, RelNode rel) {
        return (PhysicalRel)context.optimize(rel, PhysicalRules.getRuleSet(), OptUtils.toPhysicalConvention(rel.getTraitSet()));
    }

    private SqlRowMetadata createRowMetadata(List<String> columnNames, List<QueryDataType> columnTypes) {
        assert (columnNames.size() == columnTypes.size());
        ArrayList<SqlColumnMetadata> columns = new ArrayList<SqlColumnMetadata>(columnNames.size());
        for (int i = 0; i < columnNames.size(); ++i) {
            SqlColumnMetadata column = QueryUtils.getColumnMetadata((String)columnNames.get(i), (QueryDataType)columnTypes.get(i), (boolean)true);
            columns.add(column);
        }
        return new SqlRowMetadata(columns);
    }

    private DAG createDag(PhysicalRel physicalRel) {
        CreateDagVisitor visitor = new CreateDagVisitor(this.nodeEngine.getLocalMember().getAddress());
        physicalRel.accept(visitor);
        return visitor.getDag();
    }
}

