/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.kafka;

import com.hazelcast.jet.sql.impl.connector.keyvalue.JavaClassNameResolver;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

final class PropertiesResolver {
    static final String KEY_SERIALIZER = "key.serializer";
    static final String KEY_DESERIALIZER = "key.deserializer";
    static final String VALUE_SERIALIZER = "value.serializer";
    static final String VALUE_DESERIALIZER = "value.deserializer";
    private static final Set<String> NON_KAFKA_OPTIONS = new HashSet<String>(){
        {
            this.add("keyFormat");
            this.add("keyJavaClass");
            this.add("valueFormat");
            this.add("valueJavaClass");
        }
    };
    private static final String SHORT_SERIALIZER = "org.apache.kafka.common.serialization.ShortSerializer";
    private static final String SHORT_DESERIALIZER = "org.apache.kafka.common.serialization.ShortDeserializer";
    private static final String INT_SERIALIZER = "org.apache.kafka.common.serialization.IntegerSerializer";
    private static final String INT_DESERIALIZER = "org.apache.kafka.common.serialization.IntegerDeserializer";
    private static final String LONG_SERIALIZER = "org.apache.kafka.common.serialization.LongSerializer";
    private static final String LONG_DESERIALIZER = "org.apache.kafka.common.serialization.LongDeserializer";
    private static final String FLOAT_SERIALIZER = "org.apache.kafka.common.serialization.FloatSerializer";
    private static final String FLOAT_DESERIALIZER = "org.apache.kafka.common.serialization.FloatDeserializer";
    private static final String DOUBLE_SERIALIZER = "org.apache.kafka.common.serialization.DoubleSerializer";
    private static final String DOUBLE_DESERIALIZER = "org.apache.kafka.common.serialization.DoubleDeserializer";
    private static final String STRING_SERIALIZER = "org.apache.kafka.common.serialization.StringSerializer";
    private static final String STRING_DESERIALIZER = "org.apache.kafka.common.serialization.StringDeserializer";
    private static final String AVRO_SERIALIZER = "io.confluent.kafka.serializers.KafkaAvroSerializer";
    private static final String AVRO_DESERIALIZER = "io.confluent.kafka.serializers.KafkaAvroDeserializer";
    private static final String BYTE_ARRAY_SERIALIZER = "org.apache.kafka.common.serialization.ByteArraySerializer";
    private static final String BYTE_ARRAY_DESERIALIZER = "org.apache.kafka.common.serialization.ByteArrayDeserializer";

    private PropertiesResolver() {
    }

    static Properties resolveConsumerProperties(Map<String, String> options) {
        Properties properties = PropertiesResolver.from(options);
        PropertiesResolver.withSerdeConsumerProperties(true, options, properties);
        PropertiesResolver.withSerdeConsumerProperties(false, options, properties);
        return properties;
    }

    static Properties resolveProducerProperties(Map<String, String> options) {
        Properties properties = PropertiesResolver.from(options);
        PropertiesResolver.withSerdeProducerProperties(true, options, properties);
        PropertiesResolver.withSerdeProducerProperties(false, options, properties);
        return properties;
    }

    private static Properties from(Map<String, String> options) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (NON_KAFKA_OPTIONS.contains(key)) continue;
            properties.put(key, value);
        }
        return properties;
    }

    private static void withSerdeConsumerProperties(boolean isKey, Map<String, String> options, Properties properties) {
        String deserializer = isKey ? KEY_DESERIALIZER : VALUE_DESERIALIZER;
        String format = options.get(isKey ? "keyFormat" : "valueFormat");
        if (format == null && isKey) {
            properties.putIfAbsent(deserializer, BYTE_ARRAY_DESERIALIZER);
        } else if ("avro".equals(format)) {
            properties.putIfAbsent(deserializer, AVRO_DESERIALIZER);
        } else if ("json".equals(format)) {
            properties.putIfAbsent(deserializer, BYTE_ARRAY_DESERIALIZER);
        } else if ("java".equals(format)) {
            String clazz = options.get(isKey ? "keyJavaClass" : "valueJavaClass");
            String deserializerClass = PropertiesResolver.resolveDeserializer(clazz);
            if (deserializerClass != null) {
                properties.putIfAbsent(deserializer, deserializerClass);
            }
        } else {
            String deserializerClass;
            String resolvedClass = JavaClassNameResolver.resolveClassName(format);
            if (resolvedClass != null && (deserializerClass = PropertiesResolver.resolveDeserializer(resolvedClass)) != null) {
                properties.putIfAbsent(deserializer, deserializerClass);
            }
        }
    }

    private static String resolveDeserializer(String clazz) {
        if (Short.class.getName().equals(clazz) || Short.TYPE.getName().equals(clazz)) {
            return SHORT_DESERIALIZER;
        }
        if (Integer.class.getName().equals(clazz) || Integer.TYPE.getName().equals(clazz)) {
            return INT_DESERIALIZER;
        }
        if (Long.class.getName().equals(clazz) || Long.TYPE.getName().equals(clazz)) {
            return LONG_DESERIALIZER;
        }
        if (Float.class.getName().equals(clazz) || Float.TYPE.getName().equals(clazz)) {
            return FLOAT_DESERIALIZER;
        }
        if (Double.class.getName().equals(clazz) || Double.TYPE.getName().equals(clazz)) {
            return DOUBLE_DESERIALIZER;
        }
        if (String.class.getName().equals(clazz)) {
            return STRING_DESERIALIZER;
        }
        return null;
    }

    private static void withSerdeProducerProperties(boolean isKey, Map<String, String> options, Properties properties) {
        String serializer = isKey ? KEY_SERIALIZER : VALUE_SERIALIZER;
        String format = options.get(isKey ? "keyFormat" : "valueFormat");
        if (format == null && isKey) {
            properties.putIfAbsent(serializer, BYTE_ARRAY_SERIALIZER);
        } else if ("avro".equals(format)) {
            properties.putIfAbsent(serializer, AVRO_SERIALIZER);
        } else if ("json".equals(format)) {
            properties.putIfAbsent(serializer, BYTE_ARRAY_SERIALIZER);
        } else if ("java".equals(format)) {
            String clazz = options.get(isKey ? "keyJavaClass" : "valueJavaClass");
            String serializerClass = PropertiesResolver.resolveSerializer(clazz);
            if (serializerClass != null) {
                properties.putIfAbsent(serializer, serializerClass);
            }
        } else {
            String serializerClass;
            String resolvedClass = JavaClassNameResolver.resolveClassName(format);
            if (resolvedClass != null && (serializerClass = PropertiesResolver.resolveSerializer(resolvedClass)) != null) {
                properties.putIfAbsent(serializer, serializerClass);
            }
        }
    }

    private static String resolveSerializer(String clazz) {
        if (Short.class.getName().equals(clazz) || Short.TYPE.getName().equals(clazz)) {
            return SHORT_SERIALIZER;
        }
        if (Integer.class.getName().equals(clazz) || Integer.TYPE.getName().equals(clazz)) {
            return INT_SERIALIZER;
        }
        if (Long.class.getName().equals(clazz) || Long.TYPE.getName().equals(clazz)) {
            return LONG_SERIALIZER;
        }
        if (Float.class.getName().equals(clazz) || Float.TYPE.getName().equals(clazz)) {
            return FLOAT_SERIALIZER;
        }
        if (Double.class.getName().equals(clazz) || Double.TYPE.getName().equals(clazz)) {
            return DOUBLE_SERIALIZER;
        }
        if (String.class.getName().equals(clazz)) {
            return STRING_SERIALIZER;
        }
        return null;
    }
}

