/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.sql.impl.connector.generator.StreamSqlConnector;
import com.hazelcast.jet.sql.impl.connector.generator.StreamTable;
import com.hazelcast.jet.sql.impl.schema.JetSpecificTableFunction;
import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.jet.sql.impl.validate.operand.NamedOperandCheckerProgram;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTableStatistic;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.OperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operand.OperandCheckerProgram;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.schema.Table;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;

public final class StreamGeneratorTableFunction
extends JetSpecificTableFunction {
    private static final String SCHEMA_NAME_STREAM = "stream";
    private static final String FUNCTION_NAME = "GENERATE_STREAM";
    private static final List<String> PARAM_NAMES = Collections.singletonList("rate");

    public StreamGeneratorTableFunction() {
        super(FUNCTION_NAME, binding -> StreamGeneratorTableFunction.toTable(0).getRowType(binding.getTypeFactory()), (SqlOperandTypeInference)new ReplaceUnknownOperandTypeInference(SqlTypeName.INTEGER), StreamSqlConnector.INSTANCE);
    }

    public List<String> getParamNames() {
        return PARAM_NAMES;
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of((int)1);
    }

    protected boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        if (ValidationUtil.hasAssignment(binding.getCall())) {
            return new NamedOperandCheckerProgram(new OperandChecker[]{TypedOperandChecker.INTEGER}).check(binding, throwOnFailure);
        }
        return new OperandCheckerProgram(new OperandChecker[]{TypedOperandChecker.INTEGER}).check(binding, throwOnFailure);
    }

    @Override
    public HazelcastTable toTable(List<Object> arguments) {
        Integer rate = (Integer)arguments.get(0);
        return StreamGeneratorTableFunction.toTable(rate);
    }

    private static HazelcastTable toTable(Integer rate) {
        StreamTable table = StreamSqlConnector.createTable(SCHEMA_NAME_STREAM, StreamGeneratorTableFunction.randomName(), rate);
        return new HazelcastTable((Table)table, (Statistic)new HazelcastTableStatistic(Integer.MAX_VALUE));
    }

    private static String randomName() {
        return "stream_" + UuidUtil.newUnsecureUuidString().replace('-', '_');
    }
}

