/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.SourceBuilder;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.SimpleExpressionEvalContext;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

class SeriesTable
extends JetTable {
    private final Integer start;
    private final Integer stop;
    private final Integer step;

    SeriesTable(SqlConnector sqlConnector, List<TableField> fields, String schemaName, String name, Integer start, Integer stop, Integer step) {
        super(sqlConnector, fields, schemaName, name, (TableStatistics)new ConstantTableStatistics(SeriesTable.numberOfItems(start, stop, step)));
        this.start = start;
        this.stop = stop;
        this.step = step;
    }

    BatchSource<Object[]> items(Expression<Boolean> predicate, List<Expression<?>> projections) {
        if (this.start == null || this.stop == null || this.step == null) {
            throw QueryException.error((String)"null arguments to GENERATE_SERIES functions");
        }
        if (this.step == 0) {
            throw QueryException.error((String)"step cannot equal zero");
        }
        int start = this.start;
        int stop = this.stop;
        int step = this.step;
        return SourceBuilder.batch((String)"series", (FunctionEx & Serializable)ctx -> {
            InternalSerializationService serializationService = ((Contexts.ProcSupplierCtx)ctx).serializationService();
            SimpleExpressionEvalContext context = new SimpleExpressionEvalContext(serializationService);
            return new DataGenerator(start, stop, step, predicate, projections, context);
        }).fillBufferFn((BiConsumerEx & Serializable)(rec$, x$0) -> ((DataGenerator)rec$).fillBuffer((SourceBuilder.SourceBuffer<Object[]>)x$0)).build();
    }

    long numberOfItems() {
        return SeriesTable.numberOfItems(this.start, this.stop, this.step);
    }

    private static long numberOfItems(Integer start, Integer stop, Integer step) {
        if (start == null || stop == null || step == null || step == 0) {
            return 0L;
        }
        if (start <= stop) {
            return step < 0 ? 0L : ((long)stop.intValue() - (long)start.intValue()) / (long)step.intValue() + 1L;
        }
        return step > 0 ? 0L : ((long)start.intValue() - (long)stop.intValue()) / (long)(-step.intValue()) + 1L;
    }

    private static final class DataGenerator {
        private static final int MAX_BATCH_SIZE = 1024;
        private final Iterator<Object[]> iterator;

        private DataGenerator(int start, int stop, int step, Expression<Boolean> predicate, List<Expression<?>> projections, SimpleExpressionEvalContext context) {
            this.iterator = IntStream.iterate(start, i -> i + step).limit(SeriesTable.numberOfItems(start, stop, step)).mapToObj(i -> ExpressionUtil.evaluate(predicate, projections, new Object[]{i}, (ExpressionEvalContext)context)).filter(Objects::nonNull).iterator();
        }

        private void fillBuffer(SourceBuilder.SourceBuffer<Object[]> buffer) {
            for (int i = 0; i < 1024; ++i) {
                if (!this.iterator.hasNext()) {
                    buffer.close();
                    return;
                }
                buffer.add((Object)this.iterator.next());
            }
        }
    }
}

