/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.util.ServiceLoader;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class SqlConnectorCache {
    private static final String FACTORY_ID = "com.hazelcast.sql.Connectors";
    private final Map<String, SqlConnector> connectors = new HashMap<String, SqlConnector>();

    public SqlConnectorCache(NodeEngine nodeEngine) {
        try {
            ServiceLoader.iterator(SqlConnector.class, (String)FACTORY_ID, (ClassLoader)nodeEngine.getConfigClassLoader()).forEachRemaining(this::addConnector);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addConnector(SqlConnector connector) {
        String type = connector.typeName();
        String canonicalType = SqlConnectorCache.toCanonicalType(type);
        if (this.connectors.putIfAbsent(canonicalType, connector) != null) {
            throw new HazelcastException("Duplicate connector: " + type);
        }
    }

    public SqlConnector forType(String type) {
        String canonicalType = SqlConnectorCache.toCanonicalType(type);
        return Objects.requireNonNull(this.connectors.get(canonicalType), "Unknown connector type: " + type);
    }

    private static String toCanonicalType(String type) {
        return type.toUpperCase(Locale.ENGLISH);
    }
}

