/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.internal.util.Preconditions;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.sql.type.SqlTypeName;

public class JetTableFunctionParameter
implements FunctionParameter {
    private final int ordinal;
    private final String name;
    private final SqlTypeName type;
    private final boolean required;

    public JetTableFunctionParameter(int ordinal, String name, SqlTypeName type, boolean required) {
        this.ordinal = ordinal;
        this.name = name;
        Preconditions.checkTrue((type == SqlTypeName.INTEGER || type == SqlTypeName.VARCHAR || type == SqlTypeName.MAP ? 1 : 0) != 0, (String)("Unsupported type: " + type));
        this.type = type;
        this.required = required;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public RelDataType getType(RelDataTypeFactory typeFactory) {
        return this.type == SqlTypeName.INTEGER || this.type == SqlTypeName.VARCHAR ? typeFactory.createSqlType(this.type) : typeFactory.createMapType(typeFactory.createSqlType(SqlTypeName.VARCHAR), typeFactory.createSqlType(SqlTypeName.VARCHAR));
    }

    public boolean isOptional() {
        return !this.required;
    }
}

