/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecordBuilder;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class PortableUpsertTarget
implements UpsertTarget {
    private final ClassDefinition classDefinition;
    private final Object[] values;

    PortableUpsertTarget(@Nonnull ClassDefinition classDef) {
        this.classDefinition = classDef;
        this.values = new Object[classDef.getFieldCount()];
    }

    @Override
    public UpsertInjector createInjector(@Nullable String path, QueryDataType type) {
        if (path == null) {
            return UpsertInjector.FAILING_TOP_LEVEL_INJECTOR;
        }
        int fieldIndex = this.classDefinition.hasField(path) ? this.classDefinition.getField(path).getIndex() : -1;
        return value -> {
            if (fieldIndex == -1 && value != null) {
                throw QueryException.error((String)("Unable to inject a non-null value to \"" + path + "\""));
            }
            if (fieldIndex > -1) {
                this.values[fieldIndex] = value;
            }
        };
    }

    @Override
    public void init() {
        Arrays.fill(this.values, null);
    }

    @Override
    public Object conclude() {
        GenericRecord record = PortableUpsertTarget.toRecord(this.classDefinition, this.values);
        Arrays.fill(this.values, null);
        return record;
    }

    private static GenericRecord toRecord(ClassDefinition classDefinition, Object[] values) {
        PortableGenericRecordBuilder portable = new PortableGenericRecordBuilder(classDefinition);
        for (int i = 0; i < classDefinition.getFieldCount(); ++i) {
            FieldDefinition fieldDefinition = classDefinition.getField(i);
            String name = fieldDefinition.getName();
            FieldType type = fieldDefinition.getType();
            Object value = values[i];
            try {
                switch (type) {
                    case BOOLEAN: {
                        portable.setBoolean(name, value != null && (Boolean)value != false);
                        break;
                    }
                    case BYTE: {
                        portable.setByte(name, value == null ? (byte)0 : (Byte)value);
                        break;
                    }
                    case SHORT: {
                        portable.setShort(name, value == null ? (short)0 : (Short)value);
                        break;
                    }
                    case CHAR: {
                        portable.setChar(name, value == null ? (char)'\u0000' : ((Character)value).charValue());
                        break;
                    }
                    case INT: {
                        portable.setInt(name, value == null ? 0 : (Integer)value);
                        break;
                    }
                    case LONG: {
                        portable.setLong(name, value == null ? 0L : (Long)value);
                        break;
                    }
                    case FLOAT: {
                        portable.setFloat(name, value == null ? 0.0f : ((Float)value).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        portable.setDouble(name, value == null ? 0.0 : (Double)value);
                        break;
                    }
                    case DECIMAL: {
                        portable.setDecimal(name, (BigDecimal)value);
                        break;
                    }
                    case UTF: {
                        portable.setString(name, (String)QueryDataType.VARCHAR.convert(value));
                        break;
                    }
                    case TIME: {
                        portable.setTime(name, (LocalTime)value);
                        break;
                    }
                    case DATE: {
                        portable.setDate(name, (LocalDate)value);
                        break;
                    }
                    case TIMESTAMP: {
                        portable.setTimestamp(name, (LocalDateTime)value);
                        break;
                    }
                    case TIMESTAMP_WITH_TIMEZONE: {
                        portable.setTimestampWithTimezone(name, (OffsetDateTime)value);
                        break;
                    }
                    case PORTABLE: {
                        portable.setGenericRecord(name, (GenericRecord)value);
                        break;
                    }
                    case BOOLEAN_ARRAY: {
                        portable.setBooleanArray(name, (boolean[])value);
                        break;
                    }
                    case BYTE_ARRAY: {
                        portable.setByteArray(name, (byte[])value);
                        break;
                    }
                    case SHORT_ARRAY: {
                        portable.setShortArray(name, (short[])value);
                        break;
                    }
                    case CHAR_ARRAY: {
                        portable.setCharArray(name, (char[])value);
                        break;
                    }
                    case INT_ARRAY: {
                        portable.setIntArray(name, (int[])value);
                        break;
                    }
                    case LONG_ARRAY: {
                        portable.setLongArray(name, (long[])value);
                        break;
                    }
                    case FLOAT_ARRAY: {
                        portable.setFloatArray(name, (float[])value);
                        break;
                    }
                    case DOUBLE_ARRAY: {
                        portable.setDoubleArray(name, (double[])value);
                        break;
                    }
                    case DECIMAL_ARRAY: {
                        portable.setDecimalArray(name, (BigDecimal[])value);
                        break;
                    }
                    case UTF_ARRAY: {
                        portable.setStringArray(name, (String[])value);
                        break;
                    }
                    case TIME_ARRAY: {
                        portable.setTimeArray(name, (LocalTime[])value);
                        break;
                    }
                    case DATE_ARRAY: {
                        portable.setDateArray(name, (LocalDate[])value);
                        break;
                    }
                    case TIMESTAMP_ARRAY: {
                        portable.setTimestampArray(name, (LocalDateTime[])value);
                        break;
                    }
                    case TIMESTAMP_WITH_TIMEZONE_ARRAY: {
                        portable.setTimestampWithTimezoneArray(name, (OffsetDateTime[])value);
                        break;
                    }
                    case PORTABLE_ARRAY: {
                        portable.setGenericRecordArray(name, (GenericRecord[])value);
                        break;
                    }
                    default: {
                        throw QueryException.error((String)("Unsupported type: " + type));
                    }
                }
                continue;
            }
            catch (Exception e) {
                throw QueryException.error((String)("Cannot set value " + (value == null ? "null" : " of type " + value.getClass().getName()) + " to field \"" + name + "\" of type " + type + ": " + e.getMessage()), (Throwable)e);
            }
        }
        return portable.build();
    }
}

